/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Timer;
import se.kth.netzack.Config;
import se.kth.netzack.DeathListener;
import se.kth.netzack.Direction;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.PacketListener;
import se.kth.netzack.PeerListener;
import se.kth.netzack.Player;
import se.kth.netzack.Server;
import se.kth.netzack.ZFrame;

class Game
extends Thread
implements PacketListener,
KeyListener,
DeathListener,
ActionListener,
PeerListener {
    public Map players;
    public int me;
    int highestIdSeen;
    boolean running;
    int FPS;
    String name;
    Color color;
    private final Timer timer;
    private boolean released;
    private KeyEvent releaseEvent;
    public boolean alone;
    public boolean waiting;
    ZFrame frame;
    Server server;
    ActionListener taskPerformer;
    Timer t;
    long prev;
    boolean check;

    private /* synthetic */ void finit$() {
        this.players = Collections.synchronizedMap(new HashMap());
        this.me = 0;
        this.highestIdSeen = 1;
        this.running = true;
        this.FPS = 16;
        this.released = false;
        this.alone = true;
        this.waiting = false;
        this.taskPerformer = new ActionListener(this){
            private /* synthetic */ Game this$0;
            {
                this.this$0 = game;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.server.send(Packet.roundPacket(this.this$0.me, true));
                this.this$0.startRound();
                this.this$0.waiting = false;
            }
        };
        this.t = new Timer(1500, this.taskPerformer);
        this.prev = 0L;
        this.check = false;
    }

    Game(int n, String string, int n2, String string2, Color color) {
        this.finit$();
        this.FPS = n;
        this.timer = new Timer(1, this);
        this.frame = new ZFrame(this);
        this.server = new Server(this, string, n2);
        this.server.addPeerListener(this);
        this.server.addPacketListener(this);
        this.frame.canvas.addKeyListener(this);
        this.frame.addKeyListener(this);
        this.t.setRepeats(false);
        if (string2.length() == 0) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.name = System.getProperty("user.name") + "@" + inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.name = "Captain-O Fancy-Pants";
            }
        } else {
            this.name = string2;
        }
        this.color = color;
        this.server.play();
    }

    public void setNickname(String string) {
        if (string.length() != 0) {
            this.name = string;
        }
    }

    public void setColor(Color color) {
        Map map = this.players;
        synchronized (map) {
            block3: {
                try {
                    Player player = (Player)this.players.get(new Integer(this.me));
                    if (player == null) break block3;
                    player.worm.color = color;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
            Object var4_4 = null;
        }
        this.color = color;
    }

    public int generateId() {
        return ++this.highestIdSeen;
    }

    public void seeId(int n) {
        if (n > this.highestIdSeen) {
            this.highestIdSeen = n;
        }
    }

    public void thisIsMe(int n) {
        this.me = n;
        this.seeId(this.me);
        Netzack.verbose("I'm #" + this.me + ".");
        Map map = this.players;
        synchronized (map) {
            Player player;
            try {
                player = new Player(this.me, this.name, this.color);
                player.worm.color = this.color;
                player.addDeathListener(this);
                this.players.put(new Integer(this.me), player);
            }
            finally {
                player = null;
            }
            return;
        }
    }

    public void death(Player player) {
        if (player.id == this.me) {
            this.frame.console("You died...");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void peerConnected(int n) {
        if (!this.alone) return;
        Map map = this.players;
        synchronized (map) {
            Player player;
            try {
                player = (Player)this.players.get(new Integer(this.me));
                player.isPlaying = false;
            }
            finally {
                player = null;
            }
            this.newRound();
            return;
        }
    }

    public void peerQuit(int n) {
        Map map = this.players;
        synchronized (map) {
            Player player;
            block4: {
                try {
                    player = (Player)this.players.get(new Integer(n));
                    if (player == null) break block4;
                    this.frame.console(player.name + " left the game. Bastard.");
                    this.players.remove(new Integer(n));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            player = null;
        }
        if (this.players.size() == 1) {
            this.alone = true;
        }
    }

    public void iWon() {
        this.frame.console("You won...");
        Map map = this.players;
        synchronized (map) {
            Player player;
            try {
                player = (Player)this.players.get(new Integer(this.me));
                ++player.score;
                player.isPlaying = false;
            }
            finally {
                player = null;
            }
            this.newRound();
            return;
        }
    }

    public void newRound() {
        this.server.send(Packet.roundPacket(this.me, false));
        this.nextPosition();
        this.t.start();
        this.waiting = true;
    }

    private boolean startRound() {
        if (this.players.isEmpty()) {
            return false;
        }
        Map map = this.players;
        synchronized (map) {
            Player player;
            try {
                Iterator iterator = this.players.values().iterator();
                while (iterator.hasNext()) {
                    Player player2 = (Player)iterator.next();
                    if (!player2.isPlaying) continue;
                    boolean bl = false;
                    Object var5_6 = null;
                    return bl;
                }
                iterator = this.players.values().iterator();
                while (iterator.hasNext()) {
                    player = (Player)iterator.next();
                    player.startPlaying();
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
            player = null;
        }
        this.frame.clear();
        this.frame.updateScore();
        boolean bl = true;
        return bl;
    }

    private void nextPosition() {
        Player player;
        this.frame.updateScore();
        Map map = this.players;
        synchronized (map) {
            block4: {
                try {
                    player = (Player)this.players.get(new Integer(this.me));
                    if (player == null) break block4;
                    player.nextX = (int)Math.round(Math.random() * (double)(Config.X - 100)) + 50;
                    player.nextY = (int)Math.round(Math.random() * (double)(Config.Y - 100)) + 50;
                    player.nextA = Math.random() * 2.0 * Math.PI;
                    player.isReady = true;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
        if (player != null) {
            this.server.send(Packet.posPacket(this.me, player.nextX, player.nextY, player.nextA, this.color.getRGB(), player.score, this.name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gotPacket(Server server, Packet packet) {
        Message message = packet.getMsg();
        if (message.equals(Message.POS)) {
            int n = packet.readInt();
            int n2 = packet.readInt();
            int n3 = packet.readInt();
            double d = packet.readDouble();
            Color color = new Color(packet.readInt());
            int n4 = packet.readInt();
            String string = packet.readString();
            this.seeId(n);
            Map map = this.players;
            synchronized (map) {
                Player player;
                try {
                    player = (Player)this.players.get(new Integer(n));
                    if (player == null) {
                        this.frame.console(string + " has joined.");
                        this.alone = false;
                        player = new Player(n, string, color);
                        this.players.put(new Integer(n), player);
                    }
                    player.nextX = n2;
                    player.nextY = n3;
                    player.nextA = d;
                    player.score = n4;
                    player.isReady = true;
                    return;
                }
                finally {
                    player = null;
                }
            }
        } else if (message.equals(Message.DIR)) {
            int n = packet.readInt();
            if (n == this.me) return;
            int n5 = packet.readInt();
            double d = packet.readDouble();
            double d2 = packet.readDouble();
            double d3 = packet.readDouble();
            this.turn(n, Direction.generate(n5), d, d2, d3);
            return;
        } else {
            if (!message.equals(Message.ROUND)) return;
            int n = packet.readInt();
            boolean bl = packet.readBoolean();
            if (bl) {
                this.startRound();
                return;
            } else {
                this.nextPosition();
                Map map = this.players;
                synchronized (map) {
                    try {
                        Iterator iterator = this.players.values().iterator();
                        while (iterator.hasNext()) {
                            Player player = (Player)iterator.next();
                            player.isPlaying = false;
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var16_26 = null;
                        throw throwable;
                    }
                }
            }
        }
    }

    public void turn(int n, Direction direction, double d, double d2, double d3) {
        Map map = this.players;
        synchronized (map) {
            Player player;
            block3: {
                try {
                    player = (Player)this.players.get(new Integer(n));
                    if (player == null) break block3;
                    player.worm.x = d;
                    player.worm.y = d2;
                    player.worm.a = d3;
                    player.turn(direction);
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    throw throwable;
                }
            }
            player = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.released = false;
        this.timer.stop();
        Map map = this.players;
        synchronized (map) {
            Player player;
            block4: {
                try {
                    player = (Player)this.players.get(new Integer(this.me));
                    if (player == null || player.worm.da != Direction.none) break block4;
                    int n = keyEvent.getKeyCode();
                    if (n == 37 && n != 39) {
                        player.worm.turn(Direction.left);
                        this.server.send(Packet.dirPacket(this.me, Direction.left, player.worm.x, player.worm.y, player.worm.a));
                        break block4;
                    }
                    if (n == 37 || n != 39) break block4;
                    player.worm.turn(Direction.right);
                    this.server.send(Packet.dirPacket(this.me, Direction.right, player.worm.x, player.worm.y, player.worm.a));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            player = null;
        }
        keyEvent.consume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.released) {
            this.releaseEvent = keyEvent;
            this.timer.restart();
        } else {
            Map map = this.players;
            synchronized (map) {
                Player player;
                block9: {
                    try {
                        player = (Player)this.players.get(new Integer(this.me));
                        if (player == null) break block9;
                        int n = keyEvent.getKeyCode();
                        if (n == 37) {
                            player.worm.turn(Direction.none);
                            this.server.send(Packet.dirPacket(this.me, Direction.none, player.worm.x, player.worm.y, player.worm.a));
                        }
                        if (n == 39) {
                            player.worm.turn(Direction.none);
                            this.server.send(Packet.dirPacket(this.me, Direction.none, player.worm.x, player.worm.y, player.worm.a));
                        }
                        if (n == 27) {
                            this.frame.dispose();
                            System.exit(0);
                            break block9;
                        }
                        if (n == 76) {
                            this.frame.viewLicense();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        throw throwable;
                    }
                }
                player = null;
            }
        }
        keyEvent.consume();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.released = true;
        this.timer.stop();
        this.keyReleased(this.releaseEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void run() {
        long l = System.currentTimeMillis();
        double d = 0.0;
        boolean bl = false;
        ActionListener actionListener = new ActionListener(this){
            private /* synthetic */ Game this$0;
            {
                this.this$0 = game;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                long l = actionEvent.getWhen();
                int n = this.this$0.frame.paintWorld(l - this.this$0.prev);
                this.this$0.prev = l;
                if (this.this$0.waiting) {
                    return;
                }
                if (!this.this$0.check && n > 1) {
                    this.this$0.check = true;
                    return;
                } else if (this.this$0.check && n == 1) {
                    Map map = this.this$0.players;
                    synchronized (map) {
                        Player player;
                        try {
                            player = (Player)this.this$0.players.get(new Integer(this.this$0.me));
                            if (player.isPlaying) {
                                this.this$0.iWon();
                            }
                            this.this$0.check = false;
                            return;
                        }
                        finally {
                            player = null;
                        }
                    }
                } else {
                    if (!this.this$0.alone) return;
                    if (n != 0) return;
                    if (this.this$0.players.size() != 1) return;
                    Map map = this.this$0.players;
                    synchronized (map) {
                        try {
                            Player player = (Player)this.this$0.players.get(new Integer(this.this$0.me));
                            if (player == null) return;
                            if (player.isPlaying) return;
                            this.this$0.newRound();
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            throw throwable;
                        }
                        return;
                    }
                }
            }
        };
        Timer timer = new Timer(1000 / this.FPS, actionListener);
        timer.start();
    }
}

