/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Timer;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.Peer;
import se.kth.netzack.Server;

public class ServerThread
extends Thread
implements ActionListener {
    ServerSocket socket;
    Server server;
    Vector peers;
    Vector prune;
    Object lock;
    private final Timer timer;

    private /* synthetic */ void finit$() {
        this.peers = new Vector(10, 5);
        this.prune = new Vector(5, 2);
    }

    ServerThread(Server server, Object object) {
        super("ServerThread");
        this.finit$();
        this.lock = object;
        try {
            this.socket = new ServerSocket(0);
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
        }
        this.timer = new Timer(1000, this);
        this.server = server;
        this.start();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        var1_1 = this.lock;
        // MONITORENTER : var1_1
        try {
            this.lock.notify();
        }
        catch (Throwable var3_4) {
            var2_3 = null;
            // MONITOREXIT : var1_1
            throw var3_4;
        }
        var2_2 = null;
        // MONITOREXIT : var1_1
        try {}
        catch (IOException var4_7) {
            return;
        }
        {
            while (true) lbl-1000:
            // 2 sources

            {
                var2_2 = this.socket.accept();
                var3_5 = this.peers;
                // MONITORENTER : var3_5
                this.peers.add(new Peer(var2_2, this.server));
                break;
            }
            catch (Throwable var5_8) {
                var4_6 = null;
                // MONITOREXIT : var3_5
                throw var5_8;
            }
            {
                var4_6 = null;
                // MONITOREXIT : var3_5
                ** while (true)
            }
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispatch(Packet packet) {
        Vector vector = this.peers;
        synchronized (vector) {
            Iterator iterator;
            try {
                if (this.peers.isEmpty()) {
                    Object var3_3 = null;
                    return;
                }
                iterator = this.peers.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    if (packet.isFrom(peer)) continue;
                    peer.send(packet);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
            iterator = null;
        }
    }

    public void checkConnections() {
        Vector vector = this.peers;
        synchronized (vector) {
            try {
                Iterator iterator = this.peers.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    if (peer.isConnected() || peer.tries >= 3) continue;
                    if (peer.tries == 0) {
                        this.prune.add(peer);
                        this.timer.restart();
                    }
                    ++peer.tries;
                    this.server.reestablish(peer.id);
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public void send(Packet packet) {
        Vector vector = this.peers;
        synchronized (vector) {
            try {
                Iterator iterator = this.peers.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    if (peer.send(packet)) continue;
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public Peer connect(InetAddress inetAddress, int n) {
        try {
            Socket socket = new Socket(inetAddress, n);
            Peer peer = new Peer(socket, this.server);
            Vector vector = this.peers;
            synchronized (vector) {
                Peer peer2;
                try {
                    this.peers.add(peer);
                }
                finally {
                    peer2 = null;
                }
                Netzack.debug("Connecting to " + inetAddress.toString() + ":" + n);
                peer2 = peer;
                return peer2;
            }
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
            Netzack.debug(inetAddress.toString());
            Peer peer = null;
            return peer;
        }
    }

    public void reconnect(int n, InetAddress inetAddress, int n2) {
        Vector vector = this.peers;
        synchronized (vector) {
            try {
                Iterator iterator = this.peers.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    if (peer.id != n) continue;
                    Peer peer2 = this.connect(inetAddress, n2);
                    Packet packet = Packet.reconnectPacket(this.server.id, n);
                    peer2.send(packet);
                    this.peers.remove(peer);
                    break;
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector = this.peers;
        synchronized (vector) {
            try {
                Iterator iterator = this.prune.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    Netzack.debug("Pruning dead peer #" + peer.id);
                    this.peers.remove(peer);
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        this.prune.clear();
        this.timer.stop();
    }

    public void reconnected(int n) {
        Vector vector = this.peers;
        synchronized (vector) {
            try {
                Iterator iterator = this.peers.iterator();
                while (iterator.hasNext()) {
                    Peer peer = (Peer)iterator.next();
                    if (peer.id != n) continue;
                    this.peers.remove(peer);
                    break;
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }
}

