/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import se.kth.netzack.Config;
import se.kth.netzack.Game;
import se.kth.netzack.ViewLicense;
import se.kth.netzack.ZCanvas;
import se.kth.netzack.ZConsole;
import se.kth.netzack.ZScoreBoard;

public class ZFrame
extends Frame
implements FocusListener {
    ZCanvas canvas;
    ZConsole console;
    ZScoreBoard board;
    Game game;

    public void console(String string) {
        this.console.print(string);
    }

    ZFrame(Game game) {
        this.game = game;
        this.canvas = new ZCanvas(this.game.players);
        this.console = new ZConsole();
        this.board = new ZScoreBoard(this.game);
        this.setTitle(Config.PRODUCT + " " + Config.VERSION);
        this.addFocusListener(this);
        this.add((Component)this.canvas, "Center");
        this.canvas.setFocusable(true);
        this.add((Component)this.board, "After");
        this.board.setFocusable(false);
        this.add((Component)this.console, "Last");
        this.console.setFocusable(false);
        this.pack();
        this.setVisible(true);
        this.board.init();
        this.pack();
        this.console.init();
        this.pack();
        this.canvas.initBuffers();
        this.addWindowListener(new WindowAdapter(this){
            private /* synthetic */ ZFrame this$0;
            {
                this.this$0 = zFrame;
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowActivated(WindowEvent windowEvent) {
                this.this$0.requestFocusInWindow();
            }
        });
        this.console(Config.COPYRIGHT);
        this.console(Config.NOTICE);
        this.pack();
        this.setResizable(false);
    }

    public void viewLicense() {
        new ViewLicense();
    }

    public void updateScore() {
        this.board.repaint();
    }

    public int paintWorld(long l) {
        return this.canvas.paintWorms(l);
    }

    public void clear() {
        this.canvas.clear();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.canvas.requestFocusInWindow();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

