/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.VolatileImage;
import java.util.Iterator;
import java.util.Map;
import se.kth.netzack.Config;
import se.kth.netzack.Game;
import se.kth.netzack.Player;

public class ZScoreBoard
extends Canvas {
    private VolatileImage img;
    private Graphics g;
    private Game game;
    private int X;
    private Font smallFont;
    private int smallLine;
    private FontMetrics smallMetrics;
    private Font bigFont;
    private int bigLine;
    private FontMetrics bigMetrics;
    private int border;

    private /* synthetic */ void finit$() {
        this.X = 200;
    }

    ZScoreBoard(Game game) {
        this.finit$();
        this.game = game;
        this.setBackground(Color.black);
        this.setSize(200, 0);
        this.setVisible(true);
    }

    void init() {
        this.smallFont = new Font(Config.FONT, 0, Config.FONT_SIZE);
        this.bigFont = new Font(Config.FONT, 3, Config.FONT_SIZE + 20);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.smallMetrics = graphics2D.getFontMetrics(this.smallFont);
        this.bigMetrics = graphics2D.getFontMetrics(this.bigFont);
        this.border = this.smallLine = this.smallMetrics.getHeight();
        this.bigLine = this.bigMetrics.getHeight();
        String string = "";
        for (int i = 0; i < Config.NICKNAME_LENGTH; ++i) {
            string = string.concat("O");
        }
        this.X = this.smallMetrics.stringWidth(string) + 2 * this.border;
        this.setSize(this.X, this.getHeight());
        this.img = this.createVolatileImage(this.getWidth(), this.getHeight());
        if (this.img == null) {
            return;
        }
        this.g = this.img.getGraphics();
        this.g.setColor(Color.black);
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void update(Graphics graphics) {
        VolatileImage volatileImage = this.img;
        synchronized (volatileImage) {
            try {
                Iterator iterator;
                this.g.setColor(Color.black);
                this.g.fillRect(0, 0, this.X, this.getHeight());
                int n = this.border;
                Map map = this.game.players;
                synchronized (map) {
                    try {
                        iterator = this.game.players.values().iterator();
                        Player player = null;
                        do {
                            if (player == null) {
                                player = (Player)this.game.players.get(new Integer(this.game.me));
                            } else {
                                player = (Player)iterator.next();
                                if (player.id == this.game.me) continue;
                            }
                            if (player == null) break;
                            this.g.setColor(player.color);
                            this.g.setFont(this.smallFont);
                            String string = player.name;
                            if (player.name.length() > Config.NICKNAME_LENGTH) {
                                string = player.name.substring(0, Config.NICKNAME_LENGTH);
                            }
                            this.g.drawString(string, (this.X - this.smallMetrics.stringWidth(string)) / 2, n);
                            String string2 = new Integer(player.score).toString();
                            this.g.setFont(this.bigFont);
                            this.g.drawString(string2, (this.X - this.smallMetrics.stringWidth(string2)) / 2, n += this.bigLine);
                            n += 2 * this.smallLine;
                        } while (iterator.hasNext());
                        iterator = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        throw throwable;
                    }
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.img != null) {
            VolatileImage volatileImage = this.img;
            synchronized (volatileImage) {
                try {
                    graphics.drawImage(this.img, 0, 0, this);
                }
                finally {
                    Object var3_3 = null;
                }
            }
        } else {
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

