#!/usr/bin/python
import unittest
import os
from testsPath import *
from config import VERSION
from SoundDevice import *
from OBBSongDocument import *

class obbSoundDeviceInitTest(unittest.TestCase):
    """obbSoundDeviceInitTest : tests if device inits."""
    def runTest(self):
        soundDevice = SoundDevice()
        self.failUnless( soundDevice != None )


class obbSoundDeviceLoadBadFileNameTest(unittest.TestCase):
    """obbSoundDeviceLoadBadFileNameTest : tests if device plays bad file name."""
    def runTest(self):
        soundDevice = SoundDevice()
        self.failUnlessRaises(Exception, soundDevice.Load, "troum")


class obbSoundDevicePlayTest(unittest.TestCase):
    """obbSoundDevicePlayTest : tests if device plays."""
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.Load("../../sounds/hat03.wav")
        soundDevice.Play(0)

class obbSoundDevicePlayInBackGroundTest(unittest.TestCase):
    """obbSoundDevicePlayInBackGroundTest : tests if device plays in background."""
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.Load("../../sounds/hat03.wav")
        soundDevice.Play()


def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(obbSoundDeviceInitTest())
    testSuite.addTest(obbSoundDeviceLoadBadFileNameTest())
    testSuite.addTest(obbSoundDevicePlayTest())
    testSuite.addTest(obbSoundDevicePlayInBackGroundTest())
    return testSuite
