#!/usr/bin/python


#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import unittest

TEST_MODULES = [ "startUpTest",
                 "OBBAppTest",
                 "soundTest",
                 "FloaterTest",
                 "PixmapSetTest",
                 ]

def generateSuite():
    testSuite = unittest.TestSuite()
    for module in TEST_MODULES:
        exec "import %s" % module
        exec "testSuite.addTest(%s.suite())" % module
    return testSuite

def main():
    runner = unittest.TextTestRunner()
    suite = generateSuite()
    runner.run( suite )

if __name__=="__main__":
    main()
