#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import unittest
from testsPath import *
from qt import *
from OBBGui.PixmapSet import *
import os
import sys
from OBBFuncts import *

class SetInitTest(unittest.TestCase):
    def runTest(self):
        set = PixmapSet()
        self.failUnless(set != None)

class SetStateAddTest(unittest.TestCase):
    def runTest(self):
        set = PixmapSet()
        pixmap = QPixmap(os.path.join(getImgDir(), "vholder.png"))
        set.addState(pixmap, DISABLED)
        newPix = set.getState(DISABLED)
                         
        self.failUnless(newPix != None)

class SetStateDoubleAddTest(unittest.TestCase):
    """ can't add the same state twice ! """
    def runTest(self):
        set = PixmapSet()
        pixmap = QPixmap(os.path.join(getImgDir(), "vholder.png"))
        set.addState( pixmap, DISABLED)

        newPixmap = QPixmap(os.path.join(getImgDir(), "vholder.png"))
        self.failUnlessRaises( StateError,
                               set.addState,
                               newPixmap,
                               DISABLED )

class SetStateMultiAddTest(unittest.TestCase):
    """ can add multiple states """
    def runTest(self):
        set = PixmapSet()
        pixmap = QPixmap(os.path.join(getImgDir(), "vholder.png"))
        set.addState( pixmap, DISABLED)

        newPixmap = QPixmap(os.path.join(getImgDir(), "holder.png"))
        set.addState( newPixmap, ACTIVATED )

        statePix = set.getState(DISABLED)
        self.failUnless( statePix != None )

        statePix = set.getState(ACTIVATED)
        self.failUnless( statePix != None )

class SetStateBadGetTest(unittest.TestCase):
    """ get bad state raises """
    def runTest(self):
        set = PixmapSet()
        pixmap = QPixmap(os.path.join(getImgDir(), "vholder.png"))
        set.addState( pixmap, DISABLED)

        self.failUnlessRaises( StateError,
                               set.getState,
                               ACTIVATED )

def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(SetInitTest())
    testSuite.addTest(SetStateAddTest())
    testSuite.addTest(SetStateDoubleAddTest())
    testSuite.addTest(SetStateBadGetTest())
    return testSuite

if __name__ == "__main__":
    app = QApplication(sys.argv)

    runner = unittest.TextTestRunner()
    runner.run( suite() )

    kickApp(app)
