/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

import opale.mathtools.DVect;
import opale.mathtools.IFnn;

public final class FixPoint {
    public static double PRECISION = 1.0E-18;
    public static int MAXITERATION = 100;
    public static int NITER = 0;

    public static boolean solve(IFnn iFnn, int n, DVect dVect, DVect dVect2) {
        boolean bl = false;
        NITER = 0;
        DVect dVect3 = new DVect(dVect.size());
        dVect2.set(dVect);
        while (NITER < MAXITERATION && !bl) {
            dVect3.set(dVect2);
            dVect2.set(iFnn.val(dVect2));
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < dVect3.size()) {
                d2 += (dVect3.get(n2) - dVect2.get(n2)) * (dVect3.get(n2) - dVect2.get(n2));
                d += dVect3.get(n2) * dVect3.get(n2);
                ++n2;
            }
            if (d2 <= PRECISION * d) {
                bl = true;
            }
            ++NITER;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        DVect dVect = new DVect(1);
        DVect dVect2 = new DVect(1);
        FixPoint.solve(new IFnn(){

            public DVect val(DVect dVect) {
                DVect dVect2 = new DVect(1);
                dVect2.set(0, -0.5 * dVect.get(0) + 1.0E19);
                return dVect2;
            }
        }, 1, dVect, dVect2);
        System.err.println(dVect2);
    }
}

