/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class StandardControl
	{
	
	public static void main(String[] arg)
	{
	Problem pb = new Problem(1);	//problme en dimension 1
	ExplicitEuler ts = new ExplicitEuler();		
	StandardStepControl contr = new StandardStepControl();
	ts.setStepsizeControl(contr);
	
	DVect cd = new DVect(1);	// vecteur pour la condition initiale
	
	ts.setNstep(30);		//nombre de pas en temps 
	ts.set(0,10);			// tude sur l'intervalle en temps (0;1)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,-x.get(0));		//x'(t,x,y,z,w) = z		
			return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	// on rsoud les quations de la dynamique
	cd.set(0,1);
	pb.setInit(cd);
	pb.solve();
	double[][] sol=pb.toArray();
	
	//System.out.println(pb.printSol());
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D(true);
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-1,2,-1,1);
	jf.getPack2D().add(repere,"repere");
	GData2D gsol = new GData2D(repere);
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
		gsol.set(pb.getNStep(),sol[0],sol[1]);
		jf.getPack2D().add(gsol,"sol");
	jf.show();
	
	
	
	}

}
