/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d.object2d;
import opale.m2d.*;
import opale.tools.*;
import opale.m2d.marktype.*;
import java.io.*;

/**
* Cette classe reprsente un nuage de points graphique; elle tend la class <code>Data2D</code>.
* @author O.C.
* @since Opale-2d 0.1
*/


public class GData2D extends Data2D implements GObject2D,  Cloneable
{
private DefaultGraphicalOptions info; 
private String legende;

/**
* Constructeur par dfaut.
*/
public GData2D()
	{
	super();
	if (Debug.On) Debug.print("Dans GData2D()");
	info = new DefaultGraphicalOptions();
	//stylept = new ClassicPoint();
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GData2D(OIJ rep)
	{
	super(rep);
	info = new DefaultGraphicalOptions();
	//stylept = new ClassicPoint();
	}
/**
* Construit et initialise le nuage  partir d'un Data2D et avec les informations par dfaut.  
* @param Data2D d, le nuage.
*/
public GData2D(Data2D d)
	{
	super(d);
	info = new DefaultGraphicalOptions();
	//stylept = new ClassicPoint();
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
*/
public GData2D(GData2D d)
	{
	super(d);
	info = new DefaultGraphicalOptions((DefaultGraphicalOptions) d.getInfo());
	}


public final int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	if ( word.equals("INFO"))
		{
		info.read(f,p);
		return 0;
		}
		
		else return super.readKeyWord(word,f,p);
	}

public void writeMore(PrintWriter f, OpaleSet p) throws InvalidFormatException
	{
	info.write(f,p);
	super.writeMore(f,p);
	}	


public void draw(Pen2D c)
	{
	int i;

	if ( info.isVisible())
		{
		c.setColor(info.getColor());
//		if ( info.getTypeGraph() == 0)
			for (i=0;i<nbPts-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
/*		else if  ( info.getTypeGraph() == 1)
			{}
		else  if  (info.getTypeGraph() == 2)		
			for (i=0;i<nbPts;i++)
				c.drawLine(x[i],0,x[i],y[i]);
		else  if  (info.getTypeGraph() == 3)		
			for (i=0;i<nbPts;i++)
				c.drawLine(0,y[i],x[i],y[i]);
		else if  ( info.getTypeGraph() == 4) 
			for (i=0;i<nbPts;i++)
				{
				c.drawLine(x[i],0,x[i],y[i]);
				c.drawLine(0,y[i],x[i],y[i]);
				}*/
				MarkType mt = info.getMarktype();
		if (!(mt instanceof ClassicPoint))
			for (i=0;i<nbPts;i++)
				mt.draw(c,x[i],y[i]);
		}
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GData2D gd = (GData2D) super.clone();
	gd.info = (DefaultGraphicalOptions) info.clone();
	return gd;
	}

public void drawLegend(Pen2D c,int x, int y,int w, int h)
	{
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
			c.drawLine(x,y+h/2,x+w,y+h/2);
		}
	}
	
public InfoObject getInfo()
	{
	return info;
	}
	
	
public String getLegend()
	{
	return info.getName();
	}
public void setLegend(String t)
	{
	info.setName(t);
	}

public double x(double t) 
{ 
return t;
}

public double y(double t) 
{  

return t;

}

}
