/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools.parser;


class Sin extends UnaryFunction { public double eval(double x) { if (getParser().isDeg()) x = Math.toRadians(x); return Math.sin(x); } 
				 public String keyword() { return "sin"; } }
				 
class Cos extends UnaryFunction { public double eval(double x) { if (getParser().isDeg()) x = Math.toRadians(x); return Math.cos(x); } 
				 public String keyword() { return "cos"; } }
				 
class Tan extends UnaryFunction { public double eval(double x) { if (getParser().isDeg()) x = Math.toRadians(x); return Math.tan(x); } 
				 public String keyword() { return "tan"; } }
				 
class Log extends UnaryFunction { public double eval(double x) { return Math.log(x); } 
				 public String keyword() { return "log"; } }
				 
class Log10 extends UnaryFunction { public double eval(double x) { return Math.log(x)/Math.log(10);  }
				 public String keyword() { return "log10"; } }
				 
class Exp extends UnaryFunction { public double eval(double x) { return Math.exp(x); } 
				 public String keyword() { return "exp"; } }
				 
class Sqrt extends UnaryFunction { public double eval(double x) { return Math.sqrt(x); } 
				 public String keyword() { return "sqrt"; } }
				 
class Abs extends UnaryFunction { public double eval(double x) { return Math.abs(x); } 
				 public String keyword() { return "abs"; } }

class Acos extends UnaryFunction { public double eval(double x) { x = Math.acos(x);  if (getParser().isDeg()) x = Math.toDegrees(x) ; return x; } 
				 public String keyword() { return "acos"; } }
				 
class Asin extends UnaryFunction { public double eval(double x) { x = Math.asin(x);  if (getParser().isDeg()) x = Math.toDegrees(x) ; return x; } 
				 public String keyword() { return "asin"; } }
				 
class Atan extends UnaryFunction { public double eval(double x) { x = Math.atan(x); if (getParser().isDeg()) x = Math.toDegrees(x) ; return x; } 
				 public String keyword() { return "atan"; } }
				 
class Rnd extends UnaryFunction { public double eval(double x) { return Math.random()*x; } 
				 public String keyword() { return "rnd"; } }
				 
class Rad extends UnaryFunction { public double eval(double x) { return Math.toRadians(x); } 
				 public String keyword() { return "rad"; } }
				 
class Deg extends UnaryFunction { public double eval(double x) { return Math.toDegrees(x); } 
				 public String keyword() { return "deg"; } }
				 

