/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.swools;
/**
 * La classe IntTextField tend <code>JTextField</code> et ne permet que la saisie de int.
 * @author O.C.
 * @since Opale-Swools 0.1
 */

import javax.swing.*;
import javax.swing.text.*;

class IntTextDocument extends PlainDocument
{  public void insertString(int offs, String str, 
			    AttributeSet a) 
       throws BadLocationException 
    {  if (str == null) return;
    String oldString = getText(0, getLength());
    String newString = oldString.substring(0, offs)
	+ str + oldString.substring(offs);
    try
	{  Integer.parseInt(newString + "0");
	super.insertString(offs, str, a);
	}
    catch(NumberFormatException e)
	{  
	}
    }
}

public class IntTextField extends JTextField 
{  public IntTextField(int defval, int size)
    {  super("" + defval, size);
    }
    public IntTextField(int size)
    {  super("" + 0, size);
    }

    protected Document createDefaultModel() 
    {  return new IntTextDocument();
    }

    public boolean isValid()
    {  try
	{  Integer.parseInt(getText());
	return true;
	}
    catch(NumberFormatException e)
	{  return false; 
	}
    }

    public int getValue()
    {  try
	{  return Integer.parseInt(getText());
	}
    catch(NumberFormatException e)
	{  return 0; 
	}
    }
}
