/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.components.JFireGraph;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JPanelConsoleInfo
extends JPanel
implements ComponentListener,
DeviceConnectListener,
DeviceCommandListener {
    private static final long serialVersionUID = 5027054951800480326L;
    private JPanel infoPanel = null;
    private boolean donePaint = false;

    public JPanelConsoleInfo() {
        this.addComponentListener(this);
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.info_data, (DeviceCommandListener)this);
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.infoPanel = this.createInfoPanel();
        this.add(this.infoPanel);
    }

    private JPanel createInfoPanel() {
        JPanel infoPanel = JComponentFactory.createJFirePanel();
        infoPanel.setLayout(new FlowLayout());
        JLabel text = new JLabel();
        text.setText("<html><center><h1>PulseFire</h1><sub>Copyright 2011 Willem Cazander</sub><br>For more information visit website;<br>http://www.nongnu.org/pulsefire/<br><sub><font face=\"monospace\">#________#_#_#_#<br>_#______________<br>__#__________#__<br>___#____________<br>____#____###__##<br>_____#____###__#</font></sub></center></html>");
        infoPanel.add(text);
        return infoPanel;
    }

    private void redoPanel() {
        int w = this.getSize().width;
        int h = this.getSize().height;
        int wMin = 200;
        int hMin = 100;
        int gW = w / wMin;
        int gH = h / hMin;
        for (Component c : this.getComponents()) {
            if (!(c instanceof JFireGraph)) continue;
            JFireGraph g = (JFireGraph)c;
            PulseFireUI.getInstance().getTimeData().removeTimeDataListener(g.getCommandName(), g);
        }
        this.removeAll();
        if (PulseFireUI.getInstance().getTimeData().getTimeDataKeys().isEmpty()) {
            this.add(this.infoPanel);
            final JPanelConsoleInfo thisPanel = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.updateComponentTreeUI(thisPanel);
                }
            });
            return;
        }
        Iterator<CommandName> i = PulseFireUI.getInstance().getTimeData().getTimeDataKeys().iterator();
        i.next();
        ArrayList<CommandName> d = new ArrayList<CommandName>(10);
        while (i.hasNext()) {
            CommandName name = i.next();
            if (name == CommandName.pwm_loop) {
                d.add(name);
                continue;
            }
            if (name == CommandName.pwm_on_cnt_a) {
                d.add(name);
                continue;
            }
            if (name == CommandName.pwm_off_cnt_a) {
                d.add(name);
                continue;
            }
            if (name.name().startsWith("pulse") || name.name().startsWith("pwm") || name.name().startsWith("ppm") || name.name().startsWith("lpm") || name.name().startsWith("ptc") || name.name().startsWith("ptt") || name.name().startsWith("ptt") || name.name().startsWith("lcd") || name.name().startsWith("mal") || name.name().startsWith("swc") || name.name().startsWith("sys") || name.name().startsWith("adc") && !name.name().startsWith("adc_value")) continue;
            d.add(name);
        }
        int ii = 0;
        for (int y = 0; y < gH; ++y) {
            for (int x = 0; x < gW && ii < d.size(); ++ii, ++x) {
                CommandName name = (CommandName)d.get(ii);
                JFireGraph g = new JFireGraph(name);
                g.setPreferredSize(new Dimension(wMin, hMin));
                this.add(g);
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.redoPanel();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void deviceConnect() {
    }

    public void deviceDisconnect() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JFireGraph)) continue;
            JFireGraph g = (JFireGraph)c;
            PulseFireUI.getInstance().getTimeData().removeTimeDataListener(g.getCommandName(), g);
        }
        this.removeAll();
        this.add(this.infoPanel);
        this.donePaint = false;
        final JPanelConsoleInfo thisPanel = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(thisPanel);
            }
        });
    }

    public void commandReceived(Command command) {
        if (this.donePaint) {
            return;
        }
        if (PulseFireUI.getInstance().getTimeData().getTimeDataKeys().isEmpty()) {
            return;
        }
        final JPanelConsoleInfo thisPanel = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelConsoleInfo.this.redoPanel();
                JPanelConsoleInfo.this.donePaint = true;
                SwingUtilities.updateComponentTreeUI(thisPanel);
            }
        });
    }
}

