/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandCheckBox;
import org.nongnu.pulsefire.device.ui.components.JCommandComboBox;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JFireBorderChild;
import org.nongnu.pulsefire.device.ui.components.JFireDial;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelPWM
extends AbstractTabPanel
implements DeviceCommandListener {
    private static final long serialVersionUID = 8834117894619851885L;
    private JPanel centerPanel = null;
    private List<JPanel> channels = null;
    private List<JPanel> channelsEmpty = null;

    public JTabPanelPWM() {
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.channels = new ArrayList<JPanel>(16);
        this.channelsEmpty = new ArrayList<JPanel>(16);
        for (int i = 0; i < 16; ++i) {
            this.channelsEmpty.add(new JPanel());
        }
        PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_steps, (DeviceCommandListener)this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel topLayoutPanel = new JPanel();
        topLayoutPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        topLayoutPanel.setLayout(new FlowLayout(0, 6, 0));
        JPanel pulsePanel = this.createTopPulse();
        topLayoutPanel.add(pulsePanel);
        JPanel pwmPanel = this.createTopPWM();
        pwmPanel.setPreferredSize(new Dimension(pwmPanel.getPreferredSize().width, pulsePanel.getPreferredSize().height));
        topLayoutPanel.add(pwmPanel);
        JPanel ppmPanel = this.createTopPPM();
        ppmPanel.setPreferredSize(new Dimension(ppmPanel.getPreferredSize().width, pulsePanel.getPreferredSize().height));
        topLayoutPanel.add(ppmPanel);
        JPanel freqPanel = this.createTopFreq();
        freqPanel.setPreferredSize(new Dimension(freqPanel.getPreferredSize().width, pulsePanel.getPreferredSize().height));
        topLayoutPanel.add(freqPanel);
        topPanel.add((Component)topLayoutPanel, "North");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new BoxLayout(splitPanel, 2));
        splitPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        splitPanel.add(this.createChannelAll());
        topPanel.add((Component)splitPanel, "Center");
        this.add(topPanel);
    }

    private JPanel createChannelAll() {
        this.centerPanel = new JPanel();
        GridLayout centerLayout = new GridLayout(1, 16, 5, 5);
        this.centerPanel.setLayout(centerLayout);
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        for (int i = 0; i < 16; ++i) {
            JPanel out = JComponentFactory.createJFirePanel("OUT" + i);
            out.setLayout(new BoxLayout(out, 3));
            JPanel boxPanel = new JPanel();
            boxPanel.setLayout(new SpringLayout());
            JCommandCheckBox boxMaskA = new JCommandCheckBox(CommandName.pulse_mask_a, i);
            boxMaskA.putClientProperty("JComponent.sizeVariant", "mini");
            boxPanel.add(boxMaskA);
            JLabel maskLabel = new JLabel("Mask");
            boxPanel.add(maskLabel);
            JCommandCheckBox boxMaskB = new JCommandCheckBox(CommandName.pulse_mask_b, i);
            boxMaskB.putClientProperty("JComponent.sizeVariant", "mini");
            boxPanel.add(boxMaskB);
            JCommandCheckBox boxInitA = new JCommandCheckBox(CommandName.pulse_init_a, i);
            boxInitA.putClientProperty("JComponent.sizeVariant", "mini");
            boxPanel.add(boxInitA);
            JLabel intiLabel = new JLabel("Init");
            boxPanel.add(intiLabel);
            JCommandCheckBox boxInitB = new JCommandCheckBox(CommandName.pulse_init_b, i);
            boxInitB.putClientProperty("JComponent.sizeVariant", "mini");
            boxPanel.add(boxInitB);
            SpringLayoutGrid.makeCompactGrid(boxPanel, 2, 3, 0, 0, 0, 0);
            out.add(boxPanel);
            JPanel dialPanel = new JPanel();
            dialPanel.setBorder(new JFireBorderChild(out));
            dialPanel.setLayout(new SpringLayout());
            JCommandDial dialA = new JCommandDial(CommandName.pwm_on_cnt_a, i);
            dialPanel.add(dialA);
            JCommandDial dialB = new JCommandDial(CommandName.pwm_on_cnt_b, i);
            dialPanel.add(dialB);
            dialPanel.add(new JCommandDial(CommandName.pwm_off_cnt_a, i));
            dialPanel.add(new JCommandDial(CommandName.pwm_off_cnt_b, i));
            SpringLayoutGrid.makeCompactGrid(dialPanel, 2, 2, 0, 0, 0, 0);
            out.add(dialPanel);
            JPanel flagsPanel = new JPanel();
            flagsPanel.setLayout(new SpringLayout());
            JPanel flags = new JPanel();
            flags.setLayout(new BoxLayout(flags, 3));
            JCheckBox pwmFlag = new JCheckBox();
            pwmFlag.setText("pwm");
            pwmFlag.setEnabled(false);
            pwmFlag.putClientProperty("JComponent.sizeVariant", "mini");
            flags.add(pwmFlag);
            JCheckBox ppmFlag = new JCheckBox();
            ppmFlag.setText("ppm");
            ppmFlag.setEnabled(false);
            ppmFlag.putClientProperty("JComponent.sizeVariant", "mini");
            flags.add(ppmFlag);
            flagsPanel.add(flags);
            flagsPanel.add(new JCommandDial(CommandName.pwm_tune_cnt, i));
            SpringLayoutGrid.makeCompactGrid(flagsPanel, 1, 2, 0, 0, 0, 0);
            out.add(flagsPanel);
            JPanel ppmPanel = new JPanel();
            ppmPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            ppmPanel.setLayout(new BorderLayout(5, 5));
            JPanel ppmPanelA = new JPanel();
            ppmPanelA.setLayout(new GridLayout(0, 2));
            for (int p = 0; p < 16; ++p) {
                JCommandCheckBox box = new JCommandCheckBox(CommandName.ppm_data_a, p, i);
                box.putClientProperty("JComponent.sizeVariant", "mini");
                box.setBorder(BorderFactory.createEmptyBorder());
                ppmPanelA.add(box);
            }
            JPanel ppmPanelT = new JPanel();
            ppmPanelT.setLayout(new GridLayout(0, 1));
            int num = 0;
            for (int p = 0; p < 8; ++p) {
                int n;
                StringBuilder buf = new StringBuilder(20);
                if ((n = num++) <= 9) {
                    buf.append('0');
                }
                buf.append(n);
                buf.append('-');
                n = num++;
                if (n <= 9) {
                    buf.append('0');
                }
                buf.append(n);
                JLabel l = new JLabel(buf.toString());
                l.setFont(UIManager.getFont("FireDial.font"));
                l.setForeground(UIManager.getColor("nimbusDisabledText"));
                ppmPanelT.add(l);
            }
            JPanel ppmPanelB = new JPanel();
            ppmPanelB.setLayout(new GridLayout(0, 2));
            for (int p = 0; p < 16; ++p) {
                JCommandCheckBox box = new JCommandCheckBox(CommandName.ppm_data_b, p, i);
                box.putClientProperty("JComponent.sizeVariant", "mini");
                ppmPanelB.add(box);
            }
            ppmPanel.add((Component)ppmPanelA, "West");
            ppmPanel.add((Component)ppmPanelT, "Center");
            ppmPanel.add((Component)ppmPanelB, "East");
            out.add(ppmPanel);
            this.centerPanel.add(out);
            this.channels.add(out);
        }
        return this.centerPanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    public void commandReceived(Command command) {
        int steps = new Integer(command.getArgu0());
        this.checkChannels(steps);
    }

    private void checkChannels(int steps) {
        Boolean limit = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LIMIT_CHANNELS);
        if (!limit.booleanValue()) {
            steps = CommandName.pulse_steps.getMaxValue();
        }
        this.centerPanel.removeAll();
        for (int i = 0; i < 16; ++i) {
            if (i >= steps) {
                this.centerPanel.add(this.channelsEmpty.get(i));
                continue;
            }
            this.centerPanel.add(this.channels.get(i));
        }
    }

    private JPanel createTopFreq() {
        JPanel borderPanel = JComponentFactory.createJFirePanel("Freq");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new FlowLayout(0, 0, 0));
        borderPanel.add(splitPanel);
        JPanel freqDialPanel = new JPanel();
        freqDialPanel.setLayout(new SpringLayout());
        splitPanel.add(freqDialPanel);
        final JFireDial freqReqDial = new JFireDial("freq", 1, 65535, 32768);
        JComponentEnableStateListener.attach(freqReqDial, CommandName.req_pwm_freq);
        freqDialPanel.add(JComponentFactory.createJPanelJWrap(freqReqDial));
        freqDialPanel.add(new JCommandDial(CommandName.pwm_duty));
        SpringLayoutGrid.makeCompactGrid(freqDialPanel, 1, 2);
        JPanel pulsePanel = new JPanel();
        pulsePanel.setLayout(new SpringLayout());
        splitPanel.add(pulsePanel);
        pulsePanel.add(JComponentFactory.createJLabel("Channel:"));
        final JComboBox<String> freqChannelBox = new JComboBox<String>(new String[]{"ALL", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"});
        JComponentEnableStateListener.attach(freqChannelBox, CommandName.req_pwm_freq);
        pulsePanel.add(freqChannelBox);
        pulsePanel.add(JComponentFactory.createJLabel("Freq:"));
        JButton freqReqButton = new JButton("Request");
        JComponentEnableStateListener.attach(freqReqButton, CommandName.req_pwm_freq);
        pulsePanel.add(freqReqButton);
        SpringLayoutGrid.makeCompactGrid(pulsePanel, 2, 2);
        freqReqButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String chStr = freqChannelBox.getSelectedItem().toString();
                if ("ALL".equals(chStr)) {
                    chStr = "255";
                }
                Command reqPwmCmd = new Command(CommandName.req_pwm_freq);
                reqPwmCmd.setArgu0("" + freqReqDial.getValue());
                reqPwmCmd.setArgu1(chStr);
                PulseFireUI.getInstance().getDeviceManager().requestCommand(reqPwmCmd);
            }
        });
        return borderPanel;
    }

    private JPanel createTopPPM() {
        JPanel resultPanel = JComponentFactory.createJFirePanel("PPM");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new FlowLayout(0, 0, 0));
        resultPanel.add(splitPanel);
        JPanel ppmPanel = new JPanel();
        ppmPanel.setLayout(new SpringLayout());
        splitPanel.add(ppmPanel);
        JCommandDial dial = null;
        dial = new JCommandDial(CommandName.ppm_data_len);
        ppmPanel.add(dial);
        dial = new JCommandDial(CommandName.ppm_data_offset);
        ppmPanel.add(dial);
        SpringLayoutGrid.makeCompactGrid(ppmPanel, 1, 2);
        return resultPanel;
    }

    private JPanel createTopPWM() {
        JPanel resultPanel = JComponentFactory.createJFirePanel("PWM");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new FlowLayout(0, 0, 0));
        resultPanel.add(splitPanel);
        JPanel pwmPanel = new JPanel();
        pwmPanel.setLayout(new SpringLayout());
        splitPanel.add(pwmPanel);
        pwmPanel.add(new JCommandDial(CommandName.pwm_loop));
        pwmPanel.add(new JCommandDial(CommandName.pwm_loop_delta));
        SpringLayoutGrid.makeCompactGrid(pwmPanel, 1, 2);
        JPanel clockPanel = new JPanel();
        clockPanel.setLayout(new SpringLayout());
        splitPanel.add(clockPanel);
        clockPanel.add(new JCommandComboBox(CommandName.pwm_clock));
        SpringLayoutGrid.makeCompactGrid(clockPanel, 1, 1);
        return resultPanel;
    }

    private JPanel createTopPulse() {
        JPanel borderPanel = JComponentFactory.createJFirePanel("Pulse");
        JPanel splitPanel = new JPanel();
        splitPanel.setLayout(new FlowLayout(0, 0, 0));
        borderPanel.add(splitPanel);
        JPanel pulsePanel = new JPanel();
        pulsePanel.setLayout(new SpringLayout());
        splitPanel.add(pulsePanel);
        pulsePanel.add(JComponentFactory.createJLabel("Mode"));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_mode));
        pulsePanel.add(JComponentFactory.createJLabel("Direction"));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_dir));
        pulsePanel.add(JComponentFactory.createJLabel("Trigger"));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_trig));
        pulsePanel.add(JComponentFactory.createJLabel("Bank"));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_bank));
        SpringLayoutGrid.makeCompactGrid(pulsePanel, 2, 4);
        JPanel delayPanel = new JPanel();
        delayPanel.setLayout(new SpringLayout());
        splitPanel.add(delayPanel);
        delayPanel.add(new JCommandDial(CommandName.pulse_trig_delay));
        delayPanel.add(new JCommandDial(CommandName.pulse_post_delay));
        SpringLayoutGrid.makeCompactGrid(delayPanel, 1, 2);
        return borderPanel;
    }
}

