/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;
import org.nongnu.pulsefire.wire.WireChipFlags;

public class JTabPanelVariables
extends AbstractTabPanel {
    private static final long serialVersionUID = -4134436278702264489L;
    private boolean filterIndexed = false;
    private String filterType = null;
    private List<DeviceConfigVariableTableModel> models = new ArrayList<DeviceConfigVariableTableModel>(4);

    public JTabPanelVariables() {
        this.setLayout(new FlowLayout(0));
        JPanel topSplit = new JPanel();
        topSplit.setLayout(new BorderLayout());
        topSplit.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createVars("Conf", CommandVariableType.CONF));
        wrap.add(this.createVars("Data", CommandVariableType.DATA));
        wrap.add(this.createVars("Prog/Chip/Freq", CommandVariableType.PROG));
        SpringLayoutGrid.makeCompactGrid(wrap, 1, 3);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        topPanel.add(this.createTopPanelFilter());
        topPanel.add(this.createTopPanelPulling());
        topSplit.add((Component)JComponentFactory.createJPanelJWrap(topPanel), "First");
        topSplit.add((Component)wrap, "Center");
        this.add(topSplit);
    }

    private void fireUpdateModels() {
        for (DeviceConfigVariableTableModel m : this.models) {
            m.fireTableDataChanged();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(JTabPanelVariables.this.getParentScrollPane());
            }
        });
    }

    private JPanel createTopPanelFilter() {
        JPanel filterPanel = JComponentFactory.createJFirePanel("Filter");
        filterPanel.setLayout(new FlowLayout(0));
        filterPanel.add(new JLabel("Filter"));
        JComboBox<WireChipFlags> filterBox = new JComboBox<WireChipFlags>(WireChipFlags.values());
        filterBox.addItem((WireChipFlags)"ALL");
        filterBox.setSelectedIndex(filterBox.getItemCount() - 1);
        filterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabPanelVariables.this.filterType = ((JComboBox)e.getSource()).getSelectedItem().toString();
                JTabPanelVariables.this.fireUpdateModels();
            }
        });
        filterPanel.add(filterBox);
        JCheckBox filterIndexedCheckBox = new JCheckBox("Indexed");
        filterIndexedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabPanelVariables.this.filterIndexed = ((JCheckBox)e.getSource()).isSelected();
                JTabPanelVariables.this.fireUpdateModels();
            }
        });
        filterPanel.add(filterIndexedCheckBox);
        return filterPanel;
    }

    private JPanel createTopPanelPulling() {
        JPanel pullPanel = JComponentFactory.createJFirePanel("Pulling");
        pullPanel.setLayout(new FlowLayout(0));
        pullPanel.add(new JLabel("Refresh"));
        JComboBox<Integer> refreshBox = new JComboBox<Integer>(new Integer[]{600000, 300000, 60000, 30000, 10000, 5000, 4000, 3000, 2000});
        refreshBox.setSelectedIndex(4);
        refreshBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTimeTrigger trig = PulseFireUI.getInstance().getEventTimeManager().getEventTimeTriggerByName("refreshData");
                if (trig != null) {
                    trig.setTimeStep(((Integer)((JComboBox)e.getSource()).getSelectedItem()).intValue());
                }
            }
        });
        pullPanel.add(refreshBox);
        return pullPanel;
    }

    private JPanel createVars(String name, CommandVariableType type) {
        JPanel confPanel = JComponentFactory.createJFirePanel(name);
        confPanel.setLayout(new GridLayout(1, 1));
        this.add(confPanel);
        DeviceConfigVariableTableModel tableConfModel = new DeviceConfigVariableTableModel(type);
        JTable tableConf = new JTable(tableConfModel);
        this.models.add(tableConfModel);
        TableColumn nameCol = tableConf.getColumnModel().getColumn(0);
        nameCol.setPreferredWidth(130);
        TableColumn valueCol = tableConf.getColumnModel().getColumn(1);
        valueCol.setPreferredWidth(130);
        tableConf.getTableHeader().setReorderingAllowed(false);
        JPanel tableConfPanel = new JPanel();
        tableConfPanel.setLayout(new BorderLayout());
        tableConfPanel.add((Component)tableConf.getTableHeader(), "First");
        tableConfPanel.add((Component)tableConf, "Center");
        confPanel.add(tableConfPanel);
        return confPanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    public class DeviceConfigVariableTableModel
    extends AbstractTableModel
    implements DeviceConnectListener,
    DeviceCommandListener {
        private static final long serialVersionUID = 6439448246187594793L;
        private String[] columnNames = new String[]{"Name", "Value"};
        private DeviceData deviceData = null;
        private CommandVariableType type = null;

        public DeviceConfigVariableTableModel(CommandVariableType type) {
            this.type = type;
            this.deviceData = PulseFireUI.getInstance().getDeviceManager().getDeviceData();
            PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.info_data, (DeviceCommandListener)this);
        }

        public void deviceConnect() {
            this.fireTableDataChanged();
        }

        public void deviceDisconnect() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.getFilteredCommandMap(this.type).size();
        }

        private Map<String, Command> getFilteredCommandMap(CommandVariableType type) {
            HashMap<String, Command> result = new HashMap<String, Command>(33);
            Map cmdMap = this.deviceData.getTypeMap(type);
            if (type.equals((Object)CommandVariableType.PROG)) {
                Map chipMap = this.deviceData.getTypeMap(CommandVariableType.CHIP);
                cmdMap.putAll(chipMap);
                Map freqMap = this.deviceData.getTypeMap(CommandVariableType.FREQ);
                cmdMap.putAll(freqMap);
            }
            for (CommandName name : cmdMap.keySet()) {
                result.put(name.name(), (Command)cmdMap.get(name));
            }
            if (JTabPanelVariables.this.filterIndexed) {
                for (CommandName cmd : CommandName.values()) {
                    if (!cmd.isIndexedA() || (type.equals((Object)CommandVariableType.PROG) ? !(cmd.getType().equals((Object)type) | cmd.getType().equals((Object)CommandVariableType.CHIP) | cmd.getType().equals((Object)CommandVariableType.FREQ)) : !cmd.getType().equals((Object)type))) continue;
                    for (int i = 0; i < cmd.getMaxIndexA(); ++i) {
                        String key = cmd.name();
                        key = i < 10 ? key + "0" + i : key + i;
                        Command cmdIdx = this.deviceData.getDeviceParameterIndexed(cmd, Integer.valueOf(i));
                        if (cmdIdx == null) continue;
                        result.put(key, cmdIdx);
                    }
                }
            }
            if (JTabPanelVariables.this.filterType == null) {
                return result;
            }
            if (JTabPanelVariables.this.filterType.isEmpty()) {
                return result;
            }
            if ("ALL".equals(JTabPanelVariables.this.filterType)) {
                return result;
            }
            String ff = JTabPanelVariables.this.filterType.toLowerCase();
            HashMap<String, Command> resultFiltered = new HashMap<String, Command>(33);
            for (String name : result.keySet()) {
                if (!name.startsWith(ff)) continue;
                resultFiltered.put(name, (Command)result.get(name));
            }
            return resultFiltered;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map<String, Command> cmdMap = this.getFilteredCommandMap(this.type);
            ArrayList<String> keys = new ArrayList<String>(cmdMap.size());
            keys.addAll(cmdMap.keySet());
            Collections.sort(keys);
            Command cmd = cmdMap.get(keys.get(row));
            if (cmd == null) {
                return "ErrNoCmd";
            }
            if (col == 0) {
                return keys.get(row);
            }
            if (cmd.getCommandName().isIndexedA() && cmd.getCommandName().isIndexedB()) {
                return cmd.getLineRaw().substring(3);
            }
            if (cmd.getCommandName().isIndexedA()) {
                return cmd.getLineRaw().substring(0, cmd.getLineRaw().length() - 3);
            }
            return cmd.getLineRaw();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void commandReceived(Command command) {
            this.fireTableDataChanged();
        }
    }
}

