/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.wire.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.AbstractDeviceWireManager;
import org.nongnu.pulsefire.device.DeviceCommandRequest;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.serial.SerialDeviceWireThread;

public class SerialDeviceWireManager
extends AbstractDeviceWireManager {
    private Logger logger = Logger.getLogger(SerialDeviceWireManager.class.getName());
    private SerialDeviceWireThread serialThread = null;

    public List<String> getDevicePorts() {
        ArrayList<String> result = new ArrayList<String>(10);
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier cpi = (CommPortIdentifier)e.nextElement();
                if (cpi.getPortType() != 1) continue;
                result.add(cpi.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logger.info("Total ports found: " + result.size());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String port) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException, InterruptedException {
        if (this.isConnected()) {
            this.disconnect();
        }
        long startTime = System.currentTimeMillis();
        this.sendCommandQueue.clear();
        this.connectPhase = "Opening port";
        this.connectProgress = 1;
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier o = (CommPortIdentifier)e.nextElement();
            this.logger.finer("Rescan port: " + o.getName());
        }
        boolean done = false;
        try {
            CommPortIdentifier cpi = CommPortIdentifier.getPortIdentifier((String)port);
            SerialPort serialPort = (SerialPort)cpi.open("PulseFire", 2000);
            serialPort.setSerialPortParams(115200, 8, 1, 0);
            serialPort.setFlowControlMode(0);
            this.connectPhase = "Start IO thread";
            this.connectProgress = 2;
            this.serialThread = new SerialDeviceWireThread(this, serialPort);
            this.serialThread.setName("PulseFire-IO");
            this.serialThread.start();
            while (!this.serialThread.isRunning()) {
                Thread.sleep(200L);
            }
            this.connectPhase = "Arduino booting";
            this.connectProgress = 5;
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(1000L);
                if (this.serialThread == null) {
                    boolean bl = false;
                    return bl;
                }
                if (this.serialThread.hasSeenPromt()) break;
            }
            this.connectPhase = "Check info_chip";
            this.connectProgress = 7;
            DeviceCommandRequest infoChip = this.requestCommand(new Command(CommandName.info_chip));
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(100L);
                if (this.serialThread == null) {
                    boolean bl = false;
                    return bl;
                }
                if (infoChip.getResponse() != null) break;
            }
            boolean result = this.doSafeConnect(infoChip);
            done = true;
            long stopTime = System.currentTimeMillis();
            this.logger.info("Succesfully connected in " + (stopTime - startTime) + " ms.");
            boolean bl = result;
            return bl;
        }
        finally {
            if (!done) {
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.serialThread == null) {
            return;
        }
        this.requestCommand(new Command(CommandName.req_tx_push, "0")).waitForResponse();
        this.serialThread.shutdown();
        this.serialThread = null;
        super.disconnect();
    }
}

