/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.wire;

import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.WireChipFlags;
import org.nongnu.pulsefire.wire.WirePulseMode;

public class CommandNameVersionFactory {
    public static final int CURRENT_VERSION = 10;

    public static void configCommandMax(int version, CommandName commandName, int value) {
        commandName.maxValue = value;
    }

    public static void configCommandMapIndex(int version, CommandName commandName, int value) {
        commandName.mapIndex = value;
    }

    public static void configCommandMaxIndexA(int version, CommandName commandName, int value) {
        commandName.maxIndexA = value;
    }

    public static void configCommandMaxIndexB(int version, CommandName commandName, int value) {
        commandName.maxIndexB = value;
    }

    public static void configCommandMaxIndexTrigger(int version, CommandName commandName, boolean value) {
        commandName.mapIndexTrigger = value;
    }

    public static boolean configCommandName(int version) {
        if (version == 10) {
            return CommandNameVersionFactory.configCurrentVersion();
        }
        if (version == 9) {
            return CommandNameVersionFactory.configVersion9();
        }
        if (version == 8) {
            return CommandNameVersionFactory.configVersion8();
        }
        return false;
    }

    private static boolean configCurrentVersion() {
        for (CommandName cmd : CommandName.values()) {
            cmd.maxValue = 65535;
            cmd.maxIndexA = -1;
            cmd.maxIndexB = -1;
            cmd.mapIndex = -1;
            cmd.mapIndexTrigger = false;
            cmd.disabled = false;
            cmd.listValues = null;
            cmd.magicTopListValue = false;
            cmd.aliasName = null;
            cmd.pulseModeDependency = null;
        }
        CommandName.pulse_mode.listValues = WirePulseMode.getModeList();
        CommandName.pulse_steps.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_steps.listValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
        CommandName.pulse_trig.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_trig.listValues = new String[]{"INT_LOOP", "INT_FIRE", "EXT_PIN", "EXT_FIRE"};
        CommandName.pulse_dir.pulseModeDependency = new WirePulseMode[]{WirePulseMode.TRAIN, WirePulseMode.PPM, WirePulseMode.PPM_ALL, WirePulseMode.PPM_INTERL};
        CommandName.pulse_dir.listValues = new String[]{"LR", "RL", "LRRL"};
        CommandName.pulse_bank.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_bank.listValues = new String[]{"BANK_A", "BANK_B"};
        CommandName.pulse_trig_delay.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_post_delay.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_mask_a.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_mask_b.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pulse_init_a.pulseModeDependency = new WirePulseMode[]{WirePulseMode.TRAIN};
        CommandName.pulse_init_b.pulseModeDependency = new WirePulseMode[]{WirePulseMode.TRAIN};
        CommandName.pwm_on_cnt_a.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_on_cnt_b.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_off_cnt_a.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_off_cnt_b.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_tune_cnt.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_loop.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_loop_delta.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_req_idx.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_req_duty.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_req_freq.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_clock.pulseModeDependency = WirePulseMode.valuesOn();
        CommandName.pwm_clock.listValues = new String[]{"STOP", "ON_1", "ON_8", "ON_64", "ON_256", "ON_1024", "ON_EXTF", "ON_EXTR"};
        CommandName.pwm_req_idx.magicTopListValue = true;
        CommandName.pwm_req_idx.listValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "ALL"};
        CommandName.ppm_data_offset.pulseModeDependency = WirePulseMode.valuesPPM();
        CommandName.ppm_data_len.pulseModeDependency = WirePulseMode.valuesPPM();
        CommandName.ppm_data_a.pulseModeDependency = WirePulseMode.valuesPPM();
        CommandName.ppm_data_b.pulseModeDependency = WirePulseMode.valuesPPM();
        CommandName.stv_warn_mode.magicTopListValue = true;
        CommandName.stv_warn_mode.listValues = WirePulseMode.getModeList("KEEP");
        CommandName.stv_error_mode.magicTopListValue = true;
        CommandName.stv_error_mode.listValues = WirePulseMode.getModeList("KEEP");
        CommandName.lcd_size.listValues = new String[]{"LCD_2x16", "LCD_2x20", "LCD_4x20"};
        CommandName.dev_amp_dot.listValues = CommandName.dev_volt_dot.listValues = new String[]{"/0", "/10", "/100", "/1000", "/10000"};
        CommandName.dev_temp_dot.listValues = CommandName.dev_volt_dot.listValues;
        CommandName.avr_pin2_map.listValues = new String[]{"PIN2_OFF", "PIN2_TRIG_IN", "PIN2_RELAY_OUT", "PIN2_DIC2_IN", "PIN2_DIC8_IN", "PIN2_DOC2_OUT", "PIN2_DOC8_OUT", "PIN2_FREQ_IN", "PIN2_FIRE_IN"};
        CommandName.avr_pin3_map.listValues = new String[]{"PIN3_OFF", "PIN3_MENU0_IN", "PIN3_RELAY_OUT", "PIN3_DIC3_IN", "PIN3_DIC9_IN", "PIN3_DOC3_OUT", "PIN3_DOC9_OUT", "PIN3_FREQ_IN", "PIN3_FIRE_IN"};
        CommandName.avr_pin4_map.listValues = new String[]{"PIN4_OFF", "PIN4_MENU1_IN", "PIN4_RELAY_OUT", "PIN4_DIC4_IN", "PIN4_DIC10_IN", "PIN4_DOC4_OUT", "PIN4_DOC10_OUT"};
        CommandName.avr_pin5_map.listValues = new String[]{"PIN5_OFF", "PIN5_CLOCK_IN", "PIN5_RELAY_OUT", "PIN5_DIC5_IN", "PIN5_DIC11_IN", "PIN5_DOC5_OUT", "PIN5_DOC11_OUT"};
        CommandName.avr_pin18_map.listValues = new String[]{"PIN18_OFF", "PIN18_TRIG_IN", "PIN18_RELAY_OUT", "PIN18_DIC4_IN", "PIN18_DIC6_IN", "PIN18_DOC4_OUT", "PIN18_DOC6_OUT", "PIN18_FREQ_IN", "IN18_FIRE_IN"};
        CommandName.avr_pin19_map.listValues = new String[]{"PIN19_OFF", "PIN19_TRIG_IN", "PIN19_RELAY_OUT", "PIN19_DIC5_IN", "PIN19_DIC7_IN", "PIN19_DOC5_OUT", "PIN19_DOC7_OUT", "PIN19_FREQ_IN", "PIN19_FIRE_IN"};
        CommandName.avr_pin47_map.listValues = new String[]{"PIN47_OFF", "PIN47_CLOCK_IN", "PIN47_RELAY_OUT"};
        CommandName.avr_pin48_map.listValues = new String[]{"PIN48_OFF", "PIN48_MENU0_IN", "PIN48_RELAY_OUT", "PIN48_DIC4_IN", "PIN48_DIC6_IN", "PIN48_DOC4_OUT", "PIN48_DOC6_OUT"};
        CommandName.avr_pin49_map.listValues = new String[]{"PIN49_OFF", "PIN49_MENU1_IN", "PIN49_RELAY_OUT", "PIN49_DIC5_IN", "PIN49_DIC7_IN", "PIN49_DOC5_OUT", "PIN49_DOC7_OUT"};
        CommandName.swc_mode.magicTopListValue = true;
        CommandName.swc_mode.listValues = WirePulseMode.getModeList("KEEP");
        CommandName.swc_trig.magicTopListValue = true;
        CommandName.swc_trig.listValues = new String[]{"PTT_0", "PTT_1", "PTT_2", "PTT_3", "NONE"};
        CommandName.freq_pwm_data.maxIndexA = 16;
        CommandName.freq_pwm_data.maxIndexB = 3;
        CommandName.req_ptt_fire.maxIndexA = 3;
        return true;
    }

    private static boolean configVersion9() {
        CommandNameVersionFactory.configCurrentVersion();
        for (CommandName cn : CommandName.values()) {
            if (cn.chipFlagDependency == null || cn.chipFlagDependency != WireChipFlags.PWM) continue;
            cn.chipFlagDependency = null;
        }
        CommandName.pulse_trig.listValues = new String[]{"INT_LOOP", "INT_FIRE", "EXT_PIN"};
        CommandName.pwm_req_freq.disabled = true;
        CommandName.pwm_req_idx.disabled = true;
        CommandName.pwm_req_duty.aliasName = "pwm_duty";
        CommandName.dev_volt_dot.disabled = true;
        CommandName.dev_amp_dot.disabled = true;
        CommandName.dev_temp_dot.disabled = true;
        CommandName.lpm_relay_inv.disabled = true;
        CommandName.lcd_size.disabled = true;
        CommandName.adc_enable.disabled = true;
        CommandName.dic_enable.disabled = true;
        CommandName.dic_inv.disabled = true;
        CommandName.dic_sync.disabled = true;
        CommandName.req_ptt_fire.disabled = true;
        CommandName.req_mal_fire.disabled = true;
        CommandName.mal_fire.aliasName = "mal_trig";
        return true;
    }

    private static boolean configVersion8() {
        CommandNameVersionFactory.configVersion9();
        CommandName.pulse_trig.aliasName = "pulse_trigger";
        CommandName.pulse_mode.listValues = new String[]{WirePulseMode.OFF.name(), WirePulseMode.FLASH.name(), WirePulseMode.PPM.name(), WirePulseMode.PPM_ALL.name(), WirePulseMode.PPM_INTERL.name()};
        CommandName.pulse_bank.disabled = true;
        CommandName.pwm_on_cnt_b.disabled = true;
        CommandName.pwm_off_cnt_b.disabled = true;
        CommandName.ppm_data_b.disabled = true;
        CommandName.pulse_trig.aliasName = "pulse_trigger";
        CommandName.pwm_on_cnt_b.aliasName = "pwm_on_cnt";
        CommandName.pwm_off_cnt_b.aliasName = "pwm_off_cnt";
        CommandName.ppm_data_b.aliasName = "ppm_data";
        CommandName.ptc_0run.disabled = true;
        CommandName.ptc_1run.disabled = true;
        CommandName.ptc_0mul.disabled = true;
        CommandName.ptc_1mul.disabled = true;
        CommandName.ptc_0map.disabled = true;
        CommandName.ptc_1map.disabled = true;
        CommandName.ptt_0map.disabled = true;
        CommandName.ptt_1map.disabled = true;
        CommandName.ptt_2map.disabled = true;
        CommandName.ptt_3map.disabled = true;
        CommandName.avr_pin2_map.aliasName = "sys_pin2_map";
        CommandName.avr_pin2_map.listValues = new String[]{"PIN2_OFF", "PIN2_TRIG_IN", "PIN2_RELAY_OUT"};
        CommandName.avr_pin3_map.disabled = true;
        CommandName.avr_pin4_map.disabled = true;
        CommandName.avr_pin5_map.disabled = true;
        CommandName.swc_delay.aliasName = "sys_warmup_delay";
        CommandName.swc_mode.aliasName = "sys_warmup_delay";
        CommandName.swc_secs.aliasName = "sys_warmup_delay";
        CommandName.swc_duty.aliasName = "sys_warmup_delay";
        CommandName.swc_trig.disabled = true;
        return true;
    }
}

