/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTopPanelStatus
extends JPanel
implements DeviceCommandListener {
    private static final long serialVersionUID = 94571180445561814L;
    private JLabel adcLabel = null;
    private JLabel dicLabel = null;
    private JLabel docLabel = null;

    public JTopPanelStatus() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(1, 0));
        JPanel borderPanel = JComponentFactory.createJFirePanel("Status");
        this.add(borderPanel);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new SpringLayout());
        borderPanel.add(inputPanel);
        inputPanel.add(new JLabel("Analog-In:"));
        this.adcLabel = new JLabel();
        inputPanel.add(this.adcLabel);
        inputPanel.add(new JLabel("Digital-In:"));
        this.dicLabel = new JLabel();
        inputPanel.add(this.dicLabel);
        inputPanel.add(new JLabel("Digital-Out:"));
        this.docLabel = new JLabel();
        inputPanel.add(this.docLabel);
        SpringLayoutGrid.makeCompactGrid(inputPanel, 3, 2);
        DeviceWireManager deviceManager = PulseFireUI.getInstance().getDeviceManager();
        deviceManager.addDeviceCommandListener(CommandName.adc_value, (DeviceCommandListener)this);
        deviceManager.addDeviceCommandListener(CommandName.dic_value, (DeviceCommandListener)this);
        deviceManager.addDeviceCommandListener(CommandName.doc_port, (DeviceCommandListener)this);
    }

    public void commandReceived(Command command) {
        int i;
        StringBuilder buf;
        DeviceData deviceData = PulseFireUI.getInstance().getDeviceManager().getDeviceData();
        if (command.getCommandName().equals((Object)CommandName.adc_value)) {
            buf = new StringBuilder(100);
            int crIdx = 0;
            for (int i2 = CommandName.adc_value.getMaxIndexA(); i2 >= 0; --i2) {
                Command cmd = deviceData.getDeviceParameterIndexed(command, Integer.valueOf(i2));
                if (cmd == null) continue;
                buf.append("A");
                buf.append(i2);
                buf.append(": ");
                String adcValue = cmd.getArgu0();
                if (adcValue.length() == 3) {
                    buf.append("0");
                } else if (adcValue.length() == 2) {
                    buf.append("00");
                } else if (adcValue.length() == 1) {
                    buf.append("000");
                }
                buf.append(adcValue);
                if (++crIdx == 8) {
                    buf.append("\n");
                    continue;
                }
                buf.append("  ");
            }
            this.adcLabel.setText(buf.toString());
        }
        if (command.getCommandName().equals((Object)CommandName.dic_value)) {
            buf = new StringBuilder(100);
            buf.append("0b");
            for (i = 15; i >= 0; --i) {
                int value = new Integer(command.getArgu0());
                int result = value >> i & 1;
                buf.append(result);
            }
            buf.append(" (15-0)");
            this.dicLabel.setText(buf.toString());
        }
        if (command.getCommandName().equals((Object)CommandName.doc_port)) {
            buf = new StringBuilder(100);
            buf.append("0b");
            for (i = 15; i >= 0; --i) {
                Command cmd = deviceData.getDeviceParameterIndexed(command, Integer.valueOf(i));
                if (cmd == null) continue;
                buf.append(cmd.getArgu0());
            }
            buf.append(" (15-0)");
            this.docLabel.setText(buf.toString());
        }
    }
}

