/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JFireQMapTable;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelPTC
extends AbstractTabPanel
implements DeviceCommandListener {
    private static final long serialVersionUID = -1646229038565969537L;
    private JLabel statusLabelTimer0 = null;
    private JLabel statusLabelTimer1 = null;

    public JTabPanelPTC() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createTimeConfPanel0());
        wrap.add(this.createTimeConfPanel1());
        wrap.add(this.createTimePanel0());
        wrap.add(this.createTimePanel1());
        SpringLayoutGrid.makeCompactGrid(wrap, 2, 2);
        this.add(wrap);
        DeviceWireManager deviceManager = PulseFireUI.getInstance().getDeviceManager();
        deviceManager.addDeviceCommandListener(CommandName.info_data, (DeviceCommandListener)this);
    }

    private JPanel createTimeConfPanel0() {
        JPanel panel = JComponentFactory.createJFirePanel("Config Timer 0");
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel("Run Times"));
        panel.add(new JCommandDial(CommandName.ptc_0run));
        panel.add(new JLabel("Time Multi"));
        panel.add(new JCommandDial(CommandName.ptc_0mul));
        this.statusLabelTimer0 = new JLabel();
        panel.add(this.statusLabelTimer0);
        return panel;
    }

    private JPanel createTimeConfPanel1() {
        JPanel panel = JComponentFactory.createJFirePanel("Config Timer 1");
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel("Run Times"));
        panel.add(new JCommandDial(CommandName.ptc_1run));
        panel.add(new JLabel("Time Multi"));
        panel.add(new JCommandDial(CommandName.ptc_1mul));
        this.statusLabelTimer1 = new JLabel();
        panel.add(this.statusLabelTimer1);
        return panel;
    }

    private JPanel createTimePanel0() {
        JPanel panel = JComponentFactory.createJFirePanel("Slots Timer 0");
        panel.add(new JFireQMapTable(CommandName.ptc_0map, "value", "time"));
        return panel;
    }

    private JPanel createTimePanel1() {
        JPanel panel = JComponentFactory.createJFirePanel("Slots Timer 1");
        panel.add(new JFireQMapTable(CommandName.ptc_1map, "value", "time"));
        return panel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    public void commandReceived(Command command) {
        DeviceData deviceData = PulseFireUI.getInstance().getDeviceManager().getDeviceData();
        StringBuilder buf = new StringBuilder(100);
        buf.append(CommandName.ptc_0cnt.name());
        buf.append(": ");
        buf.append(deviceData.getDeviceParameter(CommandName.ptc_0cnt).getArgu0());
        this.statusLabelTimer0.setText(buf.toString());
        buf = new StringBuilder(100);
        buf.append(CommandName.ptc_1cnt.name());
        buf.append(": ");
        buf.append(deviceData.getDeviceParameter(CommandName.ptc_1cnt).getArgu0());
        this.statusLabelTimer1.setText(buf.toString());
    }
}

