/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.time;

import java.util.ArrayList;
import java.util.List;
import org.nongnu.pulsefire.device.ui.time.EventTimeThread;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;

public class EventTimeManager {
    private EventTimeThread eventTimeThread = null;
    private List<EventTimeTrigger> eventTimeTriggers = new ArrayList<EventTimeTrigger>(100);

    public boolean isRunning() {
        return this.eventTimeThread != null;
    }

    public void start() {
        this.eventTimeThread = new EventTimeThread(this);
        this.eventTimeThread.setName("PulseFire-Timer");
        this.eventTimeThread.start();
    }

    public void shutdown() {
        this.eventTimeThread.shutdown();
        this.eventTimeThread = null;
    }

    public void addEventTimeTrigger(EventTimeTrigger eventTimeTrigger) {
        this.eventTimeTriggers.add(eventTimeTrigger);
    }

    public void removeEventTimeTrigger(EventTimeTrigger eventTimeTrigger) {
        this.eventTimeTriggers.remove(eventTimeTrigger);
    }

    public EventTimeTrigger getEventTimeTriggerByName(String name) {
        for (EventTimeTrigger e : this.eventTimeTriggers) {
            if (!e.getTriggerName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public List<EventTimeTrigger> getEventExecuteSteps() {
        ArrayList<EventTimeTrigger> result = new ArrayList<EventTimeTrigger>(20);
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.eventTimeTriggers.size(); ++i) {
            EventTimeTrigger t = this.eventTimeTriggers.get(i);
            if (t.getTimeNextRun() >= currentTime) continue;
            result.add(t);
        }
        return result;
    }
}

