/*
 * Copyright (c) 2011, Willem Cazander
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided
 * that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *   following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 *   the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.nongnu.pulsefire.device.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

/**
 * JCommandButton
 * 
 * @author Willem Cazander
 */
public class JCommandButton extends JButton implements ActionListener {

	private static final long serialVersionUID = -5019912933607846942L;
	private Command command = null;
	
	public JCommandButton(CommandName commandName) {
		this(commandName,null);
	}
	
	public JCommandButton(CommandName commandName,Integer index) {
		super();
		if (commandName==null) {
			throw new NullPointerException("Can't make command button with null command name.");
		}
		setName("commandname."+commandName.name()+".button");
		command = new Command(commandName);
		if (index != null) {
			command.setArgu0(index.toString());
			setName("commandname."+commandName.name()+index+".button");
		}
		setText(PulseFireUI.getInstance().getContext().getResourceMap().getString(getName()+".text"));	// fill i18n
		addActionListener(this);
		JComponentEnableStateListener.attach(this,commandName);
	}
	
	/**
	 * Special version for trigger buttons.
	 * @param commandName
	 * @param argument
	 * @param index
	 */
	public JCommandButton(CommandName commandName,CommandName argument,Integer index) {
		super();
		setName("commandname."+argument.name()+".button");
		command = new Command(commandName);
		command.setArgu0(argument.name());
		if (index != null) {
			command.setArgu1(index.toString());
			setName("commandname."+argument.name()+index+".button");
		}
		setText(PulseFireUI.getInstance().getContext().getResourceMap().getString(getName()+".text"));	// fill i18n
		addActionListener(this);
		JComponentEnableStateListener.attach(this,argument); // mm
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		PulseFireUI.getInstance().getDeviceManager().requestCommand(command);
	}
}
