/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.PulseFireUI;

public class JConnectDialog
extends JDialog
implements MouseListener {
    private static final long serialVersionUID = 3128697350365724499L;
    private JProgressBar bar = null;
    private Logger logger = Logger.getLogger(JConnectDialog.class.getName());

    public JConnectDialog(JFrame parentFrame, String port) {
        super(parentFrame, "Connect", true);
        this.bar = new JProgressBar(0, 100);
        this.bar.setStringPainted(true);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        topPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel cancelButton = new JLabel("cancel");
        cancelButton.addMouseListener(this);
        topPanel.add(new JLabel("Connecting....."));
        topPanel.add(cancelButton);
        this.add("Center", this.bar);
        this.add("North", topPanel);
        this.setDefaultCloseOperation(0);
        this.setSize(300, 75);
        this.setLocationRelativeTo(parentFrame);
        this.setResizable(false);
        new UpdateProgressThread().start();
        new ConnectThread(port).start();
        this.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        PulseFireUI.getInstance().getDeviceManager().disconnect(false);
        this.bar.setString("Canceled");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(333L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JConnectDialog.this.setVisible(false);
                JConnectDialog.this.dispose();
            }
        });
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class ConnectThread
    extends Thread {
        private String port = null;

        public ConnectThread(String port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                PulseFireUI.getInstance().getDeviceManager().connect(this.port);
            }
            catch (Exception connectException) {
                JConnectDialog.this.logger.log(Level.WARNING, connectException.getMessage(), connectException);
            }
        }
    }

    class UpdateProgressThread
    extends Thread {
        UpdateProgressThread() {
        }

        @Override
        public void run() {
            DeviceWireManager sm = PulseFireUI.getInstance().getDeviceManager();
            for (int i = 0; i < 200; ++i) {
                int progress = sm.getConnectProgress();
                if (progress >= 100) {
                    try {
                        Thread.sleep(333L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JConnectDialog.this.setVisible(false);
                            JConnectDialog.this.dispose();
                        }
                    });
                    return;
                }
                JConnectDialog.this.bar.setValue(progress);
                JConnectDialog.this.bar.setString(sm.getConnectPhase());
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            JConnectDialog.this.bar.setValue(100);
            JConnectDialog.this.bar.setString(sm.getConnectPhase());
            try {
                Thread.sleep(333L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JConnectDialog.this.setVisible(false);
                    JConnectDialog.this.dispose();
                }
            });
        }
    }
}

