/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.time;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.ui.time.EventTimeThread;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;

public class EventTimeManager {
    private Logger logger = Logger.getLogger(EventTimeManager.class.getName());
    private EventTimeThread eventTimeThread = null;
    private List<EventTimeTrigger> eventTimeTriggers = new ArrayList<EventTimeTrigger>(100);

    public boolean isRunning() {
        return this.eventTimeThread != null;
    }

    public void start() {
        this.eventTimeThread = new EventTimeThread(this);
        this.eventTimeThread.setName("PulseFire-Timer");
        this.eventTimeThread.start();
    }

    public void shutdown() {
        this.eventTimeThread.shutdown();
        this.eventTimeThread = null;
    }

    public void addRunOnce(Runnable run) {
        if (run == null) {
            throw new NullPointerException("Can't execute null runnable object.");
        }
        EventTimeTrigger t = new EventTimeTrigger("once_" + run.getClass().getSimpleName(), run, 0L);
        t.setTimeRuns(1L);
        this.addEventTimeTrigger(t);
        this.logger.finer("Adding run once trigger class: " + run.getClass().getSimpleName());
    }

    public void addEventTimeTrigger(EventTimeTrigger eventTimeTrigger) {
        if (eventTimeTrigger == null) {
            throw new NullPointerException("Can't add null eventTimeTrigger.");
        }
        this.eventTimeTriggers.add(eventTimeTrigger);
        this.logger.fine("Adding event trigger: " + eventTimeTrigger.getTriggerName());
    }

    public void removeEventTimeTrigger(EventTimeTrigger eventTimeTrigger) {
        if (eventTimeTrigger == null) {
            throw new NullPointerException("Can't remove null eventTimeTrigger.");
        }
        this.eventTimeTriggers.remove(eventTimeTrigger);
        this.logger.fine("Remove event trigger: " + eventTimeTrigger.getTriggerName());
    }

    public EventTimeTrigger getEventTimeTriggerByName(String name) {
        if (name == null) {
            throw new NullPointerException("Can't search on null name.");
        }
        for (EventTimeTrigger e : this.eventTimeTriggers) {
            if (!e.getTriggerName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public List<EventTimeTrigger> getEventExecuteSteps() {
        ArrayList<EventTimeTrigger> result = new ArrayList<EventTimeTrigger>(20);
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.eventTimeTriggers.size(); ++i) {
            EventTimeTrigger t = this.eventTimeTriggers.get(i);
            if (t.getTimeNextRun() >= currentTime) continue;
            result.add(t);
        }
        return result;
    }
}

