/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.nongnu.pulsefire.device.ui.components.JFireBorder;

public class JFireBorderChild
implements Border {
    private JFireBorder parentBorder = null;
    private int topBorderSize = 0;
    private int bottomBorderSize = 0;
    private int leftBorderSize = 0;

    public JFireBorderChild(JComponent parentHolder) {
        if (parentHolder == null) {
            throw new IllegalArgumentException("JComponent is null");
        }
        if (!(parentHolder.getBorder() instanceof JFireBorder)) {
            throw new IllegalArgumentException("JComponent has not JFireBorder");
        }
        this.parentBorder = (JFireBorder)parentHolder.getBorder();
        this.topBorderSize = 1;
    }

    public JFireBorderChild(JFireBorder parentBorder) {
        this(parentBorder, 1, 0, 0);
    }

    public JFireBorderChild(JFireBorder parentBorder, int topBorderSize, int bottomBorderSize, int leftBorderSize) {
        this.parentBorder = parentBorder;
        this.topBorderSize = topBorderSize;
        this.bottomBorderSize = bottomBorderSize;
        this.leftBorderSize = leftBorderSize;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.topBorderSize, 0, this.bottomBorderSize, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.parentBorder == null) {
            return;
        }
        if (this.parentBorder.getGradient() == null) {
            return;
        }
        g2.setPaint(this.parentBorder.getGradient());
        if (this.topBorderSize > 0) {
            g2.fillRect(x, y, width, this.topBorderSize);
        }
        if (this.bottomBorderSize > 0) {
            g2.fillRect(x, height - this.bottomBorderSize, width, this.bottomBorderSize);
        }
        if (this.leftBorderSize > 0) {
            g2.fillRect(0, 0, this.leftBorderSize, height);
        }
    }
}

