/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JCommandCheckBox;
import org.nongnu.pulsefire.device.ui.components.JCommandComboBox;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JCommandLabel;
import org.nongnu.pulsefire.device.ui.components.JFireQMapTable;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelPwmExt
extends AbstractFireTabPanel {
    private static final long serialVersionUID = -1646229038565969537L;

    public JTabPanelPwmExt() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new SpringLayout());
        topPanel.add(this.createPulseOutput());
        topPanel.add(this.createPulseHold());
        topPanel.add(this.createPulseTriggers());
        SpringLayoutGrid.makeCompactGrid(topPanel, 1, 3, 0, 0, 0, 0);
        wrap.add(topPanel);
        wrap.add(this.createPulseEvents());
        SpringLayoutGrid.makeCompactGrid(wrap, 2, 1, 6, 0, 6, 6);
        this.add(wrap);
    }

    private JPanel createPulseOutput() {
        JPanel topPanel = JComponentFactory.createJFirePanel("Output");
        topPanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel pulsePanel = new JPanel();
        pulsePanel.setLayout(new SpringLayout());
        pulsePanel.add(new JCommandLabel(CommandName.pulse_steps));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_steps));
        pulsePanel.add(new JCommandLabel(CommandName.pulse_enable));
        pulsePanel.add(new JCommandCheckBox(CommandName.pulse_enable));
        pulsePanel.add(new JCommandLabel(CommandName.pulse_inv));
        pulsePanel.add(new JCommandCheckBox(CommandName.pulse_inv));
        SpringLayoutGrid.makeCompactGrid(pulsePanel, 3, 2);
        topPanel.add(pulsePanel);
        return topPanel;
    }

    private JPanel createPulseTriggers() {
        JPanel butPanel = JComponentFactory.createJFirePanel("Triggers");
        butPanel.setLayout(new SpringLayout());
        butPanel.add(new JCommandButton(CommandName.req_trigger, CommandName.pulse_fire, null));
        butPanel.add(new JCommandButton(CommandName.req_trigger, CommandName.pulse_reset_fire, null));
        butPanel.add(new JCommandButton(CommandName.req_trigger, CommandName.pulse_hold_fire, null));
        butPanel.add(new JCommandButton(CommandName.req_trigger, CommandName.pulse_resume_fire, null));
        SpringLayoutGrid.makeCompactGrid(butPanel, 2, 2);
        return butPanel;
    }

    private JPanel createPulseHold() {
        JPanel firePanel = JComponentFactory.createJFirePanel("Pulse Control");
        firePanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel pulsePanel = new JPanel();
        pulsePanel.setLayout(new SpringLayout());
        pulsePanel.add(new JCommandLabel(CommandName.pulse_fire_mode));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_fire_mode));
        pulsePanel.add(new JCommandLabel(CommandName.pulse_hold_mode));
        pulsePanel.add(new JCommandComboBox(CommandName.pulse_hold_mode));
        pulsePanel.add(new JCommandLabel(CommandName.pulse_hold_autoclr));
        pulsePanel.add(new JCommandCheckBox(CommandName.pulse_hold_autoclr));
        SpringLayoutGrid.makeCompactGrid(pulsePanel, 3, 2);
        firePanel.add(pulsePanel);
        firePanel.add(new JCommandDial(CommandName.pulse_hold_auto));
        return firePanel;
    }

    private JPanel createPulseEvents() {
        JPanel firePanel = JComponentFactory.createJFirePanel("Pulse Fire Events");
        firePanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel mapPanel = new JPanel();
        mapPanel.setLayout(new SpringLayout());
        mapPanel.add(new JFireQMapTable(CommandName.pulse_fire_map, "fire", "zero"));
        mapPanel.add(new JFireQMapTable(CommandName.pulse_hold_map, "hold", "zero"));
        mapPanel.add(new JFireQMapTable(CommandName.pulse_resume_map, "resume", "zero"));
        mapPanel.add(new JFireQMapTable(CommandName.pulse_reset_map, "reset", "zero"));
        SpringLayoutGrid.makeCompactGrid(mapPanel, 2, 2);
        firePanel.add(mapPanel);
        return firePanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }
}

