/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.flash.avr;

import java.io.IOException;
import java.util.ArrayList;
import org.nongnu.pulsefire.device.flash.FlashControllerConfig;
import org.nongnu.pulsefire.device.flash.FlashException;
import org.nongnu.pulsefire.device.flash.avr.AbstractStk500Controller;
import org.nongnu.pulsefire.device.flash.avr.FlashCommandToken;
import org.nongnu.pulsefire.device.flash.avr.FlashMessage;
import org.nongnu.pulsefire.device.flash.avr.Stk500v2Command;

public class Stk500v2Controller
extends AbstractStk500Controller {
    private boolean logDebug = false;
    private int messageSeqenceNumber = 1;

    @Override
    public void prepareMessagePrefix(FlashMessage msg, FlashCommandToken command) {
        if (this.messageSeqenceNumber > 255) {
            this.messageSeqenceNumber = 1;
        }
        msg.addRequestCommand(Stk500v2Command.MESSAGE_START);
        msg.getRequest().add(this.messageSeqenceNumber++);
        msg.getRequest().add(0);
        msg.getRequest().add(0);
        msg.addRequestCommand(Stk500v2Command.TOKEN);
        msg.addRequestCommand(command);
    }

    @Override
    public void prepareMessagePostfix(FlashMessage msg, FlashCommandToken command) {
        int size = msg.getRequest().size() - 5;
        if (size > 0) {
            msg.getRequest().set(3, size);
            msg.getRequest().set(2, size >> 8);
        }
        int checksum = 0;
        for (Integer data : msg.getRequest()) {
            checksum = new Integer(checksum ^ data.byteValue()).byteValue();
        }
        msg.getRequest().add(new Integer(checksum));
    }

    @Override
    public FlashMessage sendFlashMessage(FlashMessage message) throws IOException {
        if (message == null) {
            throw new NullPointerException("Can't send null message");
        }
        if (message.getRequest().isEmpty()) {
            throw new IllegalArgumentException("Can't send empty message");
        }
        StringBuilder buf = new StringBuilder(30);
        for (Integer data : message.getRequest()) {
            this.output.write(data);
            this.output.flush();
            String hex = Integer.toHexString(data);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            if (hex.startsWith("ffffff")) {
                hex = hex.substring(6);
            }
            buf.append(hex);
        }
        this.output.flush();
        if (this.logDebug) {
            this.logMessage("Send data: " + buf + " (" + Stk500v2Command.valueOfToken(message.getRequest().get(5)) + ")");
        }
        int timeout = 500;
        while (this.input.available() == 0) {
            if (--timeout == 0) {
                throw new IOException("timeout on read.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        int msgStart = this.input.read();
        if (msgStart != Stk500v2Command.MESSAGE_START.getToken()) {
            throw new IOException("got no message_start but: " + msgStart);
        }
        int msgNum = this.input.read();
        if (msgNum > 256) {
            throw new IOException("to large message number: " + msgNum);
        }
        int sizeH = this.input.read();
        int sizeL = this.input.read();
        int size = sizeL + (sizeH << 8) + 1;
        buf = new StringBuilder(30);
        for (int i = 0; i < size; ++i) {
            int data = this.input.read();
            message.getResponse().add(data);
            String hex = Integer.toHexString(data);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            if (hex.startsWith("ffffff")) {
                hex = hex.substring(6);
            }
            buf.append(hex);
        }
        int checksum = this.input.read();
        if (this.logDebug) {
            this.logMessage("Read data: " + buf + " sum: " + checksum);
        }
        return message;
    }

    @Override
    protected void flashSafe(FlashControllerConfig flashControllerConfig) throws IOException, FlashException {
        if (flashControllerConfig == null) {
            throw new FlashException("Can't flash with null config.");
        }
        flashControllerConfig.verifyConfig();
        this.logConfig(flashControllerConfig);
        this.connectPort(flashControllerConfig);
        this.logDebug = flashControllerConfig.isLogDebug();
        if (this.output == null) {
            return;
        }
        this.progress = 1;
        this.rebootDevice();
        this.progress = 2;
        for (int i = 0; i < 5; ++i) {
            this.doFlashCommand(Stk500v2Command.CMD_SIGN_ON, new Integer[0]);
        }
        this.progress = 3;
        FlashMessage msg = this.doFlashCommand(Stk500v2Command.CMD_SIGN_ON, new Integer[0]);
        if (msg.getResponse().size() < 4) {
            throw new FlashException("not synced got less then 4 bytes: " + msg.getResponse().size());
        }
        if (msg.getResponse().get(0) != Stk500v2Command.TOKEN.getToken()) {
            throw new FlashException("not in sync; got: " + msg.getResponse().get(0) + " hex: " + Integer.toHexString(msg.getResponse().get(0)) + " wanted: " + Integer.toHexString(Stk500v2Command.TOKEN.getToken()));
        }
        if (msg.getResponse().get(1) != Stk500v2Command.CMD_SIGN_ON.getToken()) {
            throw new FlashException("not connected; got: " + msg.getResponse().get(1));
        }
        if (msg.getResponse().get(2) != Stk500v2Command.STATUS_CMD_OK.getToken()) {
            throw new FlashException("not connected; got: " + msg.getResponse().get(2));
        }
        this.logMessage("Synced communication.");
        StringBuilder buf = new StringBuilder(10);
        for (int i = 4; i < msg.getResponse().size(); ++i) {
            buf.append(Character.toChars(msg.getResponse().get(i)));
        }
        this.logMessage("Programmer: " + buf);
        FlashMessage versionHw = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_HW_VER.getToken());
        FlashMessage versionSwMajor = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_SW_MAJOR.getToken());
        FlashMessage versionSwMinor = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_SW_MINOR.getToken());
        this.logMessage("Hardware verion: " + (versionHw.getResponse().get(3) + (versionHw.getResponse().get(2) << 8)));
        this.logMessage("Firmware verion: " + (versionSwMajor.getResponse().get(3) + (versionSwMajor.getResponse().get(2) << 8)) + "." + (versionSwMinor.getResponse().get(3) + (versionSwMinor.getResponse().get(2) << 8)));
        FlashMessage topCard = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_TOPCARD_DETECT.getToken());
        this.logMessage("Topcard: " + Integer.toHexString(topCard.getResponse().get(3)));
        FlashMessage vTarget = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_VTARGET.getToken());
        double voltageTarget = new Double(vTarget.getResponse().get(3).intValue()) / 10.0;
        this.logMessage("Vtarget: " + voltageTarget);
        FlashMessage sckTime = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_SCK_DURATION.getToken());
        FlashMessage vAdjust = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_VADJUST.getToken());
        FlashMessage oscP = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_OSC_PSCALE.getToken());
        FlashMessage oscC = this.doFlashCommand(Stk500v2Command.CMD_GET_PARAMETER, Stk500v2Command.PARAM_OSC_CMATCH.getToken());
        FlashMessage resetPol = this.doFlashCommand(Stk500v2Command.CMD_SET_PARAMETER, Stk500v2Command.PARAM_RESET_POLARITY.getToken(), 1);
        this.progress = 9;
        FlashMessage enterIsp = new FlashMessage();
        this.prepareMessagePrefix(enterIsp, Stk500v2Command.CMD_ENTER_PROGMODE_ISP);
        enterIsp.getRequest().add(200);
        enterIsp.getRequest().add(100);
        enterIsp.getRequest().add(25);
        enterIsp.getRequest().add(32);
        enterIsp.getRequest().add(0);
        enterIsp.getRequest().add(83);
        enterIsp.getRequest().add(3);
        enterIsp.getRequest().add(172);
        enterIsp.getRequest().add(83);
        enterIsp.getRequest().add(0);
        enterIsp.getRequest().add(0);
        this.prepareMessagePostfix(enterIsp, Stk500v2Command.CMD_ENTER_PROGMODE_ISP);
        enterIsp = this.sendFlashMessage(enterIsp);
        this.logMessage("AVR device initialized");
        FlashMessage deviceId0 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 48, 0, 0, 0);
        FlashMessage deviceId1 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 48, 0, 1, 0);
        FlashMessage deviceId2 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 48, 0, 2, 0);
        int deviceId = deviceId2.getResponse().get(6) + (deviceId1.getResponse().get(6) << 8) + (deviceId0.getResponse().get(6) << 16);
        this.logMessage("Device signature: 0x" + Integer.toHexString(deviceId));
        if (flashControllerConfig.getDeviceSignature() > 0 && flashControllerConfig.getDeviceSignature() != deviceId) {
            throw new FlashException("Device signature is different: " + Integer.toHexString(deviceId) + " expected: " + Integer.toHexString(flashControllerConfig.getDeviceSignature()));
        }
        FlashMessage lFuse0 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 0, 0, 0);
        FlashMessage lFuse1 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 0, 0, 0);
        FlashMessage lFuse2 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 0, 0, 0);
        this.logMessage("lfuse value: 0x" + Integer.toHexString(lFuse2.getResponse().get(6)));
        FlashMessage hFuse0 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 88, 8, 0, 0);
        FlashMessage hFuse1 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 88, 8, 0, 0);
        FlashMessage hFuse2 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 88, 8, 0, 0);
        this.logMessage("hfuse value: 0x" + Integer.toHexString(hFuse2.getResponse().get(6)));
        FlashMessage eFuse0 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 8, 0, 0);
        FlashMessage eFuse1 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 8, 0, 0);
        FlashMessage eFuse2 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 80, 8, 0, 0);
        this.logMessage("efuse value: 0x" + Integer.toHexString(eFuse2.getResponse().get(6) & 7));
        if (flashControllerConfig.isFlashErase()) {
            this.logMessage("Erase flash memery.");
            FlashMessage eraseFlash0 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 160, 3, 252, 0);
            FlashMessage eraseFlash1 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 160, 3, 253, 0);
            FlashMessage eraseFlash2 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 160, 3, 254, 0);
            FlashMessage eraseFlash3 = this.doFlashCommand(Stk500v2Command.CMD_SPI_MULTI, 4, 4, 0, 160, 3, 255, 0);
        }
        FlashMessage eraseChip0 = this.doFlashCommand(Stk500v2Command.CMD_CHIP_ERASE_ISP, 9, 0, 172, 159, 127, 0);
        FlashMessage eraseChipReset = this.doFlashCommand(Stk500v2Command.CMD_SET_PARAMETER, Stk500v2Command.PARAM_RESET_POLARITY.getToken(), 1);
        FlashMessage eraseEnterIsp = new FlashMessage();
        this.prepareMessagePrefix(eraseEnterIsp, Stk500v2Command.CMD_ENTER_PROGMODE_ISP);
        eraseEnterIsp.getRequest().add(200);
        eraseEnterIsp.getRequest().add(100);
        eraseEnterIsp.getRequest().add(25);
        eraseEnterIsp.getRequest().add(32);
        eraseEnterIsp.getRequest().add(0);
        eraseEnterIsp.getRequest().add(83);
        eraseEnterIsp.getRequest().add(3);
        eraseEnterIsp.getRequest().add(172);
        eraseEnterIsp.getRequest().add(83);
        eraseEnterIsp.getRequest().add(0);
        eraseEnterIsp.getRequest().add(0);
        this.prepareMessagePostfix(eraseEnterIsp, Stk500v2Command.CMD_ENTER_PROGMODE_ISP);
        eraseEnterIsp = this.sendFlashMessage(eraseEnterIsp);
        this.progress = 10;
        byte[] dataBytes = flashControllerConfig.getFlashData();
        int pageSize = 128;
        int pages = dataBytes.length / pageSize;
        this.logMessage("Start flashing.");
        float flashTotalPercentage = 90.0f;
        if (flashControllerConfig.isFlashVerify()) {
            flashTotalPercentage = 80.0f;
        }
        this.doFlashCommand(Stk500v2Command.CMD_LOAD_ADDRESS, 0, 0, 0, 0);
        for (int i = 0; i <= pages; ++i) {
            this.progress = new Float(flashTotalPercentage / (float)pages * (float)i).intValue() + 10;
            FlashMessage flash = new FlashMessage();
            this.prepareMessagePrefix(flash, Stk500v2Command.CMD_PROGRAM_FLASH_ISP);
            flash.getRequest().add(0);
            flash.getRequest().add(pageSize);
            flash.getRequest().add(193);
            flash.getRequest().add(6);
            flash.getRequest().add(64);
            flash.getRequest().add(76);
            flash.getRequest().add(32);
            flash.getRequest().add(255);
            flash.getRequest().add(255);
            for (int d = 0; d < pageSize; ++d) {
                int byteData = 0;
                int addr = i * pageSize;
                if (addr + d < dataBytes.length) {
                    byteData = dataBytes[addr + d];
                }
                flash.getRequest().add(byteData);
            }
            this.prepareMessagePostfix(flash, Stk500v2Command.CMD_PROGRAM_FLASH_ISP);
            flash = this.sendFlashMessage(flash);
        }
        this.logMessage("Flashing is done.");
        if (flashControllerConfig.isFlashVerify()) {
            this.logMessage("Reading flash for verify.");
            this.doFlashCommand(Stk500v2Command.CMD_LOAD_ADDRESS, 0, 0, 0, 0);
            ArrayList<Integer> readBytes = new ArrayList<Integer>(flashControllerConfig.getFlashData().length);
            for (int i = 0; i <= pages; ++i) {
                this.progress = new Float(10.0f / (float)pages * (float)i).intValue() + 90;
                FlashMessage flash = new FlashMessage();
                this.prepareMessagePrefix(flash, Stk500v2Command.CMD_READ_FLASH_ISP);
                flash.getRequest().add(0);
                flash.getRequest().add(pageSize);
                flash.getRequest().add(32);
                this.prepareMessagePostfix(flash, Stk500v2Command.CMD_READ_FLASH_ISP);
                flash = this.sendFlashMessage(flash);
                for (int ii = 3; ii < flash.getResponse().size() - 1; ++ii) {
                    Integer data = flash.getResponse().get(ii);
                    readBytes.add(data);
                }
            }
            this.logMessage("Verify flash data...");
            for (int ii = 0; ii < flashControllerConfig.getFlashData().length; ++ii) {
                byte burnData = flashControllerConfig.getFlashData()[ii];
                if (ii > readBytes.size()) {
                    throw new FlashException("Missing backread bytes to verify");
                }
                byte readData = ((Integer)readBytes.get(ii)).byteValue();
                if (burnData == readData) continue;
                throw new FlashException("Mismatch on address: " + Integer.toHexString(ii) + " expected: " + Integer.toHexString(burnData) + " got: " + Integer.toHexString(readData));
            }
            this.logMessage("Verified " + readBytes.size() + " bytes flash oke.");
        }
        FlashMessage leaveIsp = new FlashMessage();
        this.prepareMessagePrefix(leaveIsp, Stk500v2Command.CMD_LEAVE_PROGMODE_ISP);
        leaveIsp.getRequest().add(1);
        leaveIsp.getRequest().add(1);
        this.prepareMessagePostfix(leaveIsp, Stk500v2Command.CMD_LEAVE_PROGMODE_ISP);
        leaveIsp = this.sendFlashMessage(leaveIsp);
        this.progress = 100;
    }
}

