/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JMalEditor;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelMal
extends AbstractFireTabPanel
implements ActionListener,
DeviceCommandListener {
    private static final long serialVersionUID = 4091488961980523054L;
    private JButton loadButton = null;
    private JButton saveButton = null;
    private JButton clearButton = null;
    private JButton fireButton = null;
    private JComboBox fireIndexBox = null;
    private JMalEditor malEditor = null;

    public JTabPanelMal() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createHeader());
        wrap.add(this.createEditor());
        SpringLayoutGrid.makeCompactGrid(wrap, 2, 1);
        this.add(wrap);
        this.deviceDisconnect();
        PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.mal_code, (DeviceCommandListener)this);
    }

    private JPanel createHeader() {
        JPanel result = JComponentFactory.createJFirePanel("Program");
        result.setLayout(new FlowLayout(0));
        result.add(new JLabel("Actions"));
        this.loadButton = new JButton("Load");
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(this);
        result.add(this.loadButton);
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(this);
        result.add(this.saveButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(this);
        result.add(this.clearButton);
        this.fireButton = new JButton("Fire");
        this.fireButton.setEnabled(false);
        this.fireButton.addActionListener(this);
        result.add(this.fireButton);
        this.fireIndexBox = new JComboBox();
        this.fireIndexBox.setEnabled(false);
        result.add(this.fireIndexBox);
        result.add(new JCommandDial(CommandName.mal_ops_fire));
        result.add(new JCommandDial(CommandName.mal_ops));
        result.add(new JCommandDial(CommandName.mal_mticks));
        return result;
    }

    private JPanel createEditor() {
        JPanel result = JComponentFactory.createJFirePanel("Editor");
        this.malEditor = new JMalEditor();
        result.add(this.malEditor);
        return result;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    @Override
    public void deviceConnect() {
        super.deviceConnect();
        if (CommandName.mal_fire.isDisabled()) {
            return;
        }
        this.fireIndexBox.removeAllItems();
        for (int i = 0; i < CommandName.mal_fire.getMaxIndexA(); ++i) {
            this.fireIndexBox.addItem(i);
        }
        this.loadButton.setEnabled(true);
    }

    @Override
    public void deviceDisconnect() {
        super.deviceDisconnect();
        this.loadButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.fireIndexBox.setEnabled(false);
        this.fireButton.setEnabled(false);
        this.malEditor.setEnabled(false);
        this.malEditor.clearData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.loadButton.equals(e.getSource())) {
            PulseFireUI.getInstance().getDeviceManager().requestCommand(new Command(CommandName.mal_code));
        } else if (this.saveButton.equals(e.getSource())) {
            List<Byte> programData = this.malEditor.saveData();
            StringBuffer buf = new StringBuffer();
            for (Byte b : programData) {
                byte high = (byte)((b & 0xF0) >> 4);
                byte low = (byte)(b & 0xF);
                buf.append(JTabPanelMal.nibble2char(high));
                buf.append(JTabPanelMal.nibble2char(low));
            }
            final String data = buf.toString();
            PulseFireUI.getInstance().getEventTimeManager().addRunOnce(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < data.length(); i += 8) {
                        Command cmd = new Command(CommandName.mal_code);
                        cmd.setArgu0("" + i / 2);
                        cmd.setArgu1("" + data.charAt(i) + data.charAt(i + 1) + data.charAt(i + 2) + data.charAt(i + 3) + data.charAt(i + 4) + data.charAt(i + 5) + data.charAt(i + 6) + data.charAt(i + 7));
                        PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd).waitForResponse();
                    }
                }
            });
        } else if (this.clearButton.equals(e.getSource()) && this.malEditor.getMaxProgramSize() > 0) {
            int i;
            ArrayList<Byte> programData = new ArrayList<Byte>(512);
            for (i = 0; i < CommandName.mal_fire.getMaxIndexA(); ++i) {
                programData.add((byte)64);
                programData.add((byte)32);
                programData.add((byte)0);
                programData.add(new Integer(4 * CommandName.mal_fire.getMaxIndexA()).byteValue());
            }
            for (i = 0; i < this.malEditor.getMaxProgramSize() - CommandName.mal_fire.getMaxIndexA() * 4; ++i) {
                programData.add(new Integer(255).byteValue());
            }
            this.malEditor.loadData(programData);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.updateComponentTreeUI(JTabPanelMal.this.getParentScrollPane());
                    SwingUtilities.updateComponentTreeUI(JTabPanelMal.this.malEditor);
                }
            });
        } else if (this.fireButton.equals(e.getSource()) && this.fireIndexBox.getSelectedIndex() >= 0) {
            Command cmd = new Command(CommandName.req_trigger);
            cmd.setArgu0("" + CommandName.mal_fire.getMapIndex());
            cmd.setArgu1(this.fireIndexBox.getSelectedItem().toString());
            PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd);
        }
    }

    private static char nibble2char(byte b) {
        byte nibble = (byte)(b & 0xF);
        if (nibble < 10) {
            return (char)(48 + nibble);
        }
        return (char)(65 + nibble - 10);
    }

    public void commandReceived(Command command) {
        if (command.getArgu1() != null) {
            return;
        }
        ArrayList<Byte> programData = new ArrayList<Byte>(512);
        String data = command.getArgu0();
        for (int i = 0; i < data.length(); i += 2) {
            char hex0 = data.charAt(i);
            char hex1 = data.charAt(i + 1);
            programData.add(Integer.valueOf(Integer.parseInt(hex0 + "" + hex1, 16)).byteValue());
        }
        this.malEditor.loadData(programData);
        this.saveButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.fireIndexBox.setEnabled(true);
        this.fireButton.setEnabled(true);
        this.malEditor.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(JTabPanelMal.this.getParentScrollPane());
                SwingUtilities.updateComponentTreeUI(JTabPanelMal.this.malEditor);
            }
        });
    }
}

