package jabber;

#   Rebot 0.10 (beta): Bot para aventuras de texto por red
#   Mdulo de comunicacin Jabber 0.4
#   http://aventuras.presi.org/rebot
#   (C) 2006,2007 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License 
#   along with this program.  If not, see <http://www.gnu.org/licenses/>. 

use Net::Jabber;
use jabber_conf;

BEGIN
{
  $mod_lang="jabber_lang_$rebot_conf::language";
  eval "require $mod_lang";
}

$jabber_id=$jabber_conf::rebot_id;
@aux=split('@',$jabber_id);
$user=$aux[0];
if ($jabber_conf::server eq '') { $jabber_server=$aux[1]; }
                           else { $jabber_server=$jabber_conf::server; }
@permitidos=@jabber_conf::allowed;
@maestros=@jabber_conf::master_users;
$canalr='';
$canal=$jabber_conf::chan;
$nick_canal=$jabber_conf::nick;
$resource='rebot_'.int(rand(30000));
$ini=0;

# Funciones requeridas por la interfaz con el ncleo de rebot

sub texto_inicial
{
  return $MSG_ini;
}

sub texto_ayuda
{
  return $MSG_help;
}

sub configurar
{
   $conexion=new Net::Jabber::Client();

   $conexion->SetCallBacks
    (
      message    => \&jabber_on_msg,
      presence   => \&jabber_on_presence,
      onconnect  => \&jabber_on_connect,
      onauth     => \&jabber_on_auth,
      iq         => \&jabber_on_iq
    );
}

sub conectar
{
   ${main::log}->eslog("$MSG_connecting $jabber_id/$resource:$jabber_conf::port",3);
   $conexion->Execute
    (
      hostname => $jabber_server,
      port     => $jabber_conf::port,
      tls      => $jabber_conf::enc,
      username => $user,
      password => $jabber_conf::password,
      resource => $resource
    );
   ${main::log}->eslog($MSG_disconnected,3);
}

sub enviar_mensaje   # Separa un texto en lneas y lo enva introduciendo un retardo
{                    # para evitar el flood (esto ltimo no suele ser necesario en jabber)
   my $texto=$_[1];
   my $donde=$_[2];
   my @lineas=split("\n",$texto); 
   foreach my $linea (@lineas)    
    { 
      if ($linea eq '') { $linea=' '; } 
      my @sublineas=functions::textwrap($linea,$jabber_conf::max_line); 
      foreach my $sublinea (@sublineas) 
       { 
         jabber_enviar_mensaje($sublinea,$donde); 
         sleep $jabber_conf::delay; 
       } 
    }    
}

sub comando           # Llamada desde tratar_texto() del nucleo de rebot si este no reconocido el comando
{                     # para que se intente reconocer el comando del mdulo
   my $donde=$_[1];
   my @texto=@_[2..4];

   my $res=jabber_comando($donde,@texto);
   return ( $res || !$jabber_conf::errors );
}


# Funciones privadas especficas de jabber


BEGIN
{

sub jabber_on_connect 
{
   ${main::log}->eslog($MSG_connected,4);
}

sub jabber_on_auth
{
   ${main::log}->eslog($MSG_aut,4);
   $conexion->PresenceSend();           # Enviar presencia inicial (para que todos vean a rebot como online)
   ${main::log}->eslog($MSG_spres,5);
   $c_quien='--interna--';
   jabber_roster();             # Pedido inicial de lista de contactos

   if ($canal)
   {
     jabber_entrar_canal($canal);
     $ini=1;
   }
}

sub jabber_on_msg   # Evento mensaje de un usuario o canal
{
   my ($sid, $msg)=@_;
   my $tipo=$msg->GetType();
   my $quien=$msg->GetFrom();
   my $texto=$msg->GetBody();

   if ( $quien eq "$canalr/$nick_canal" ||    # Ignorar los mensajes devueltos del propio rebot
        $quien eq "$jabber_conf::rebot_id/$resource" ) { return; }

   if (jabber_delay($msg->GetXML())) { return; }    # Ignorar mensajes atrasados

   ${main::log}->eslog("$MSG_msg '$quien' $MSG_type '$tipo'",3);

   if ($tipo eq 'chat' &&
        ((jabber_elimrec($quien) ne $canalr) || $jabber_conf::chan_allowed)  # Mensajes privados pero se evitan los de
      )                                                                      # identificador del canal si no estn permitidos
   {
     if ( jabber_prop($quien) ) { main::tratar_texto($texto,$quien); }
   }
   elsif ($tipo eq 'groupchat')             # Mensajes del canal
   {
     if ( jabber_prop($quien) ) { main::tratar_texto($texto); }
   }
}

sub jabber_on_presence     # Eventos de presencia
{
   my ($sid, $presence)=@_;
   my $quien=$presence->GetFrom();
   my $tipo=$presence->GetType();
   my $show=$presence->GetShow();
   my $donde=$c_donde;

   ${main::log}->eslog("$MSG_pres '$quien' $MSG_type '$tipo' $MSG_status '$show'",3);

   if ($quien eq "$canal/$nick_canal")   # Confirmacin de entrada en un canal o error intentndolo
   {
     if ($tipo eq 'error') { enviar_mensaje('jabber',"$MSG_nochan '$canal'",$donde); main::modo('',$donde); }
     elsif ($tipo eq '')
     {
       $canalr=$canal;
       ${main::log}->eslog("$MSG_chan '$canal'",4);
       if ($ini)
       {                # Mostrar mensaje inicial en canal inicial
         $ini=0;
         enviar_mensaje('jabber',$main::texto_inicial."\n".texto_inicial());
         main::modo('comando');
         return;
       }
       main::modo('',$donde);
     }
     return;
   }
   if ( jabber_esta_en($quien,\@permitidos) || jabber_esta_en($quien,\@maestros) || ($#permitidos==-1) )
   {
     if ($tipo eq 'subscribe')  # Peticin de subscripcin, aadimos al usuario
     {
       $conexion->PresenceSend(to=>$quien,type=>'subscribed');
       $conexion->PresenceSend(to=>$quien,type=>'subscribe');
     }
     elsif ($tipo eq 'unsubscribe') # Peticin de borrado, lo borramos nosotros tambin
     {
       $conexion->PresenceSend(to=>$quien,type=>'unsubscribed');
       $conexion->PresenceSend(to=>$quien,type=>'unsubscribe');
     }
     elsif ($tipo eq 'subscribed') { ${main::log}->eslog("$MSG_subs $quien",3); }
     elsif ($tipo eq 'unsubscribed') { ${main::log}->eslog("$MSG_usubs $quien",3); }
     elsif ( ($tipo eq '') || ($tipo eq 'available') )
     {                                              # Actualizando estado de los contactos
       if ( ($show eq '') || ($show eq 'chat') )
       {                                          # Si el contacto est online y no-away
         my @aux=split('/',$quien);
         my $usr=jabber_elimrec($quien);
         if (!functions::esta_en($aux[1],$recursos{$usr}))
           { 
             if (!defined(@recursos{$usr})) { @recursos{$usr}=[]; }
             functions::mypush(@recursos{$usr},$aux[1]);
           }
         $away{jabber_elimrec($quien)}=0;
       }
       else                             # Si el contacto est online y away
       {
         my @aux=split('/',$quien);
         my $usr=jabber_elimrec($quien);
         if (!functions::esta_en($aux[1],$recursos{$usr}))
           { 
             if (!defined(@recursos{$usr})) { @recursos{$usr}=[]; }
             functions::mypush(@recursos{$usr},$aux[1]);
           }
         $away{jabber_elimrec($quien)}=1;
       }
     }
     elsif ($tipo eq 'unavailable')   # Si un contacto se desconecta, lleva control de recursos (clientes)
     {                                # solo se marca como desconectado cuando desconecta el ltimo cliente
       my @rec=split('/',$quien);     # si haba ms de uno
       my $usr=jabber_elimrec($quien);
       functions::elimarr(@recursos{$usr},$rec[1]);
     }
   }
}

sub jabber_on_iq    # Eventos de query
{
   my ($sid,$iq)=@_;

   my $from=$iq->GetFrom();
   my $to=$iq->GetTo();
   my $tipo=$iq->GetType();
   my $quien=$c_quien;
   $c_quien='';

   ${main::log}->eslog("$MSG_iq '$from' $MSG_type '$tipo'",3);
   if ( ($tipo eq 'result') && ($from eq "$jabber_id/$resource") && ($to eq "$jabber_id/$resource") )
   {
     %blist=$conexion->RosterParse($iq);    # Recibiendo la lista de contactos
     if ( ($quien ne '--interna--') && ($quien ne '') )
     {
       foreach my $contacto (keys(%blist))    # Mostrar lista de contactos
       {
         my $estado='';
         if (jabber_online($contacto))
           { if (jabber_away($contacto))
                  { $estado=' z '; }
             else { $estado=' + '; }
           }
         else { $estado=' - '; }
         if (functions::esta_en($contacto,\@permitidos))
              { $estado=$estado.' * '; }
         else { $estado=$estado.'   '; }
         if (functions::esta_en($contacto,\@maestros))
              { $estado=$estado.' @ '; }
         else { $estado=$estado.'   '; }
         if ($blist{$contacto}->{'subscription'} eq 'both')
              { $estado=$estado.'    '; }
         else { $estado=$estado.' X  '; }
         enviar_mensaje('jabber',$estado.$contacto,$quien);
       }
       main::modo('',$quien);
     }
   }
}


sub jabber_enviar_mensaje
{
   my $texto=$_[0];
   my $quien=$_[1];
   my $tipo='chat';

   if ($quien eq '') { $quien=$canalr; $tipo='groupchat'; }

   $conexion->MessageSend(to=>$quien,body=>$texto,type=>$tipo);
}

sub jabber_roster     # Peticin de lista de contactos, se devolver como un evento IQ tratado en jabber_on_iq()
{
  $conexion->Send('<iq id="'.$$.'" type="get"><query xmlns="jabber:iq:roster"/></iq>');
  ${main::log}->eslog($MSG_roster,5);
}

sub jabber_no_autorizado
{
  my $donde=$_[0];

  if ($jabber_conf::errors)
    {
      enviar_mensaje('jabber',$MSG_no_aut,$donde);
      main::modo('',$donde);
    }
  ${main::log}->eslog("jabber: $MSG_no_aut",3);
}

sub jabber_prop    # Comprueba si un contacto existe, est online, no est away y est permitido (o es maestro, o estn todos permitidos)
                   # o bien el "contacto" realmente es el groupchat activo
{                  # si todo esto se cumple devuelve 1, si no, devuelve 0
  my $jid=jabber_elimrec($_[0]);

  return 
   ( ($jid eq $canalr) ||
     ( jabber_exists($jid) && jabber_online($jid) && !jabber_away($jid) &&
        (jabber_esta_en($jid,\@permitidos) || jabber_esta_en($jid,\@maestros) || ($#permitidos==-1))
     )
   )
}

sub jabber_exists
{                 # Devuelve 1 si el contacto existe en la lista de contactos de jabber
  my $jid=$_[0];
  my $usr=jabber_elimrec($jid);
  my @aux=keys(%blist);

  return functions::esta_en($usr,\@aux);
}

sub jabber_online
{                 # Devuelve 1 si el contacto est conectado
  my $jid=$_[0];
  my $usr=jabber_elimrec($jid);

  if ( ($#{$recursos{$usr}}==-1) || !defined(@recursos{$usr}) )
       { return 0; }
  else { return 1; }
}

sub jabber_away
{                 # Devuelve 1 si el contacto esta en algun estado away (away, not disturb o extended away)
  my $jid=$_[0];

  if ($away{jabber_elimrec($jid)}) { return 1; }
                              else { return 0; }
}

sub jabber_elimrec
{                  # Devuelve el JID sin recurso
  my $jid=$_[0];

  my @resu=split('/',$jid);
  return $resu[0];
}

sub jabber_esta_en  # Comprueba si un JID (sin recurso) est en una lista
{
  my $jid=jabber_elimrec($_[0]);
  my $lista=$_[1];

  return functions::esta_en($jid,\@$lista);
}

sub jabber_elim_roster   # Elimina un contacto de la lista de contactos de Jabber
{
  my $jid=jabber_elimrec($_[0]);

  $conexion->Send('<iq type="set" id="'.$$.'"><query xmlns="jabber:iq:roster"><item jid="'.$jid.'" subscription="remove"/></query></iq>');
}

sub jabber_entrar_canal    # Entrada en un groupchat, si ya estaba en uno sale primero de l
{
  my $donde=$_[0];
  my $nick=$_[1];
  my $pas=$_[2];
  my $estado;

  my ($sala,$servidor,$exceso)=split('@',$donde);
  if ($exceso || !$sala || !$servidor) { enviar_mensaje('jabber',"$MSG_nochan '$donde'",$c_donde); main::modo('',$c_donde); return; }

  if ($canalr) { jabber_salir_canal(); }

  if (!$nick) { $nick=$nick_canal; }
  $canal=$donde;

  $conexion->MUCJoin(room=>$sala, server=>$servidor, nick=>$nick, password=>$pas);
}

sub jabber_salir_canal     # Salir de un canal solo si ya estaba en uno
{
  if ($canalr)
  {
    my $presencia=$conexion->_presence();

    $presencia->SetTo("$canalr/$nick_canal");
    $presencia->SetType('unavailable');
    $conexion->Send($presencia);
    ${main::log}->eslog("$MSG_schan '$canalr'",4);
    $canalr='';
    $canal='';
  }
}

sub jabber_delay   # Detectar mensajes atrasados (enviados mientras se estaba desconectado) que se ignoran
{
  my $xml=$_[0];

  if ($xml=~m/<x[^x]+xmlns='jabber:x:delay'/ || $xml=~m/<delay[^x]+xmlns='urn:xmpp:delay'/) { return 1; }
  else { return 0; }
}


sub jabber_comando   # Parser de comandos del mdulo para comandos especficos de jabber
{
  my $donde=$_[0];
  my @elem=@_[1..3];
  my $comando=$elem[0];
  my $arg=$elem[1];
  my $arg2=$elem[2];

  if ( ($jabber_conf::all_auth && jabber_prop($donde)) || jabber_esta_en($donde,\@maestros) )
  {
    if ( $comando eq $COM_contactos )   # Muestra lista de contactos de jabber
    {
       jabber_roster();
       $c_quien=$donde;
       return 1;
    }
    elsif ( $comando eq $COM_agregar ) # Agrega un contacto a la lista de contactos
    {
      if ($arg eq '') { enviar_mensaje('jabber',$MSG_no_arg,$donde); }
      else
      {
        my $cont=jabber_elimrec($arg);
        $conexion->PresenceSend(to=>$cont,type=>'subscribe');
        ${main::log}->eslog("$MSG_ssubs '$arg'",4);
      }
    }
    elsif ( $comando eq $COM_borrar ) # Elimina un contacto de la lista de contactos
    {
      if ($arg eq '') { enviar_mensaje('jabber',$MSG_no_arg,$donde); }
      else
      {
        my $cont=jabber_elimrec($arg);
        if (jabber_exists($cont))
        {
          jabber_elim_roster($cont);
          $conexion->PresenceSend(to=>$cont,type=>'unsubscribe');
          ${main::log}->eslog("$MSG_ussubs '$arg'",4);
        }
      }
    }
    elsif ( $comando eq $COM_perms )  # Muestra lista de permitidos
    {
      enviar_mensaje('jabber',join("\n",@permitidos),$donde);
    }
    elsif ( $comando eq $COM_perm )   # Aade un contacto a la lista de permitidos
    {
      if (jabber_esta_en($arg,\@permitidos)) { enviar_mensaje('jabber',$MSG_ya,$donde); }
      elsif ($arg ne '') { push(@permitidos,$arg); }
      else { enviar_mensaje('jabber',$MSG_no_arg,$donde); }
    }
    elsif ( $comando eq $COM_dene )   # Borra un contacto de la lista de permitidos
    {
      if (!functions::elimarr(\@permitidos,$arg)) { enviar_mensaje('jabber',$MSG_no_ya,$donde); }
    }
    elsif ( $comando eq $COM_canal )  # Operaciones sobre canales (groupchat)
    {
      if ($arg eq '') { enviar_mensaje('jabber',$canalr,$donde); }  # Comprobar el actual
      elsif ($arg eq $COM_ninguno) { jabber_salir_canal(); }       # Salir
      else
      {                     # Entrar
        $c_donde=$donde;
        jabber_entrar_canal($arg,'',$arg2);
        return 1;
      }
    }
    elsif ( $comando eq $COM_salir )
    {
      $conexion->Disconnect();
      ${main::log}->eslog($MSG_disconnected,3);
      exit 0;
    }
    else { return 0; }       # Comando no reconocido
  }
  else { jabber_no_autorizado($donde); return 1; } 

  main::modo('',$donde);
  return 1;                  # Comando reconocido y autorizado (ejecutado)
}

}

BEGIN      # Extrayendo mensajes y comandos para simplificar sintaxis
{
  $MSG_ini=${qq(${mod_lang}::ini)};
  $MSG_connecting=${qq(${mod_lang}::connecting)};
  $MSG_connected=${qq(${mod_lang}::connected)};
  $MSG_disconnected=${qq(${mod_lang}::disconnected)};
  $MSG_aut=${qq(${mod_lang}::aut)};
  $MSG_chan=${qq(${mod_lang}::chan)};
  $MSG_nochan=${qq(${mod_lang}::nochan)};
  $MSG_schan=${qq(${mod_lang}::schan)};
  $MSG_pres=${qq(${mod_lang}::pres)};
  $MSG_roster=${qq(${mod_lang}::roster)};
  $MSG_spres=${qq(${mod_lang}::spres)};
  $MSG_msg=${qq(${mod_lang}::msg)};
  $MSG_iq=${qq(${mod_lang}::iq)};
  $MSG_type=${qq(${mod_lang}::type)};
  $MSG_status=${qq(${mod_lang}::status)};
  $MSG_subs=${qq(${mod_lang}::subs)};
  $MSG_ssubs=${qq(${mod_lang}::ssubs)};
  $MSG_usubs=${qq(${mod_lang}::usubs)};
  $MSG_no_com=${qq(${mod_lang}::no_com)};
  $MSG_no_com_aut=${qq(${mod_lang}::no_com_aut)};
  $MSG_user=${qq(${mod_lang}::user)};
  $MSG_no_aut=${qq(${mod_lang}::no_aut)};
  $MSG_ya=${qq(${mod_lang}::ya)};
  $MSG_no_ya=${qq(${mod_lang}::no_ya)};
  $MSG_no_arg=${qq(${mod_lang}::no_arg)};
  $MSG_help=${qq(${mod_lang}::help)};
  $COM_contactos=${qq(${mod_lang}::contactos)};
  $COM_agregar=${qq(${mod_lang}::agregar)};
  $COM_borrar=${qq(${mod_lang}::borrar)};
  $COM_perms=${qq(${mod_lang}::perms)};
  $COM_perm=${qq(${mod_lang}::perm)};
  $COM_dene=${qq(${mod_lang}::dene)};
  $COM_canal=${qq(${mod_lang}::canal)};
  $COM_ninguno=${qq(${mod_lang}::ninguno)};
  $COM_finalizar=${qq(${mod_lang}::finalizar)};
  $COM_salir=${qq(${mod_lang}::salir)};
}

1;
