#!/usr/bin/perl

#   Rebot 0.6 (beta): Bot para aventuras de texto por red
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

use FileHandle;
use log;
use rebot_conf;

BEGIN
{
$d_tmp=$rebot_conf::directorio_temporal;           # Inicializando parmetros
$d_interprete=$rebot_conf::directorio_interpretes; # de configuracin
$d_aventura=$rebot_conf::directorio_aventuras;
$con=$rebot_conf::modulo_protocolo;
eval "require $con";                # Incluyendo mdulo de protocolo
}

undef $/;
$modo_comando=1;
$texto_inicial="Rebot 0.6 (beta): Bot para aventuras de texto por red. http://aventuras.presi.org/rebot\nTeclea 'ayuda' para mostrar comandos disponibles.";

sub cargar_aventura
{
  $aventura=$_[0];
  $interprete=$_[1];
  $donde=$_[2];

  my @lista_a=leer_dir($d_aventura);
  my $ave_enc=0;
  foreach my $ave (@lista_a)   # Comprobando si la aventura est en el directorio
  {
    if ($ave eq $aventura) { $ave_enc=1; }
  }
  if ($ave_enc==0)
  {
    $con->enviar_mensaje('Aventura no encontrada');
    modo('',$donde);
    log::eslog("Aventura '$aventura' no encontrada");
    return 0;
  }

  if ($interprete eq '')   # Asignando intrprete a la aventura
  {
    foreach my $aux (@rebot_conf::extensiones_interpretes)
    {
      my ($ext,$int,$opc)=@$aux;
      if ($aventura=~/\.$ext/i) { $interprete=$int; $opciones=$opc; }
    }
  }
  else    # Comprobando si el intrprete est en el directorio
  {
    my @lista_i=leer_dir($d_interprete);
      my $inter_enc=0;
    foreach my $inter (@lista_i)
    {
      if ($inter eq $interprete) { $inter_enc=1; }
    }
    if ($inter_enc==0)
    {
      $con->enviar_mensaje('Intrprete no encontrado');
      modo('',$donde);
      log::eslog("Intrprete '$interprete' no encontrado");
      return 0;
    }
  }
  # Lanzando intrprete

  open STDERR, "> $d_tmp/err_$$" or die 'Error creando fichero temporal de error';
  my $linea="$d_interprete/$interprete $opciones $d_aventura/$aventura > $d_tmp/tmp_$$";
  log::eslog($linea);
  open ESINT," | $linea" or die 'Error lanzando intrprete';
  ESINT->autoflush(1);
  sleep 2;
  open ERR,"$d_tmp/err_$$" or die 'Error abriendo fichero temporal de error';
  my $er=<ERR>;
  close(ERR);
  if ($er ne '')
  {
    log::eslog($er);
    $con->enviar_mensaje('Error lanzando el intrprete');
    modo('',$donde);
    log::eslog('Error lanzando el intrprete');
  }
  else
  {
    open LEINT, "$d_tmp/tmp_$$" or die 'Error abriendo fichero temporal';
    LEINT->autoflush(1);
    $con->enviar_mensaje("Aventura '$aventura' cargada usando el intrprete '$interprete'",$donde);
    log::eslog('Aventura cargada.');
    modo('juego',$donde);
    my $le=<LEINT>;
    decir($le,$donde);
  }
}

sub leer_dir   # Lee un directorio y lo coloca en un array
{
  my $dir=$_[0];

  opendir DIR, $dir or die 'Error leyendo directorio';
  my @lista=readdir(DIR);
  closedir(DIR);
  if ($lista[0] eq '.')
  {
    shift(@lista);
    if ($lista[0] eq '..') { shift(@lista); }
  }
  return @lista;
}

sub listar_dir  # Lee y lista un directorio
{
  my $dir=$_[0];
  my $donde=$_[1];

  my @lista=leer_dir($dir);
  decir(join("\n",@lista),$donde);
}

sub ayuda
{
  my $donde=$_[0];
  my $texto_ayuda=
'Existen dos modos de funcionamiento:
Modo comando: el bot esperar comandos para realizar
  diferentes acciones.
Modo juego: es cuando se ha cargado un juego, toda
  la entrada ir a l. Para volver al modo comando
  hay que salir del juego.
Las lneas que comiencen por . , # , \' o ! son
ignoradas (por ejemplo para poner comentarios).
Comandos del modo comando:
  ayuda
     Muestra este texto.
  cargar/jugar <aventura> [intrprete]
     Inicia una aventura con un interprete y pasa
     a modo juego.
  aventuras
     Muestra la lista de aventuras disponibles.
  intrpretes
     Muestra la lista de intrpretes disponibles.
  salir
     Termina la ejecucin del bot.'."\n".$con->texto_ayuda();
  decir($texto_ayuda,$donde);
}

sub tratar_texto    # Maneja el texto de entrada
{
   my $texto=$_[0];
   my $donde=$_[1];
   my $primero=substr($texto,0,1);

   if (($primero ne '.') && ($primero ne "'") && ($primero ne '#') && ($primero ne '!'))
   {
   if ($modo_comando)  # Parser de comandos
   {
      my @elem=split(' ',$texto);
      lc($elem[0]);
      if ( ($elem[0] eq 'cargar') || ($elem[0] eq 'jugar') )
      {
         cargar_aventura($elem[1],$elem[2],$donde);
      }
      elsif ( $elem[0] eq 'aventuras' )
      {
         listar_dir($d_aventura,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq 'interpretes' )
      {
         listar_dir($d_interprete,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq 'ayuda' )
      {
         ayuda($donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq 'salir' )
      {
         exit 0;
      }
      elsif ( ($con->comando($donde,@elem)) ) { modo('',$donde); }
      else { $con->enviar_mensaje('Comando no reconocido',$donde); modo('',$donde); }
   }
   else
   {
      print ESINT $texto,"\n";  # se le pasa al intrprete
      sleep 1;
      $le=<LEINT>;              # se obtiene respuesta vaca del intrprete
      $le=<LEINT>;              # se obtiene respuesta del intrprete
      if ($le eq '')            # se comprueba si ha acabado el interprete
      {
        log::eslog('Intrprete finalizado');
        modo('comando');
      }
      else { decir($le,$donde); }      # se vuelca la respuesta
    }
    }
}

sub decir   # Separa un texto en lneas y lo enva
{
  my $texto=$_[0];
  my $donde=$_[1];
  my @lineas=split("\n",$texto);
  my $len=@lineas;
  for ($i=0; $i<$len; $i++)
   {
     $con->enviar_mensaje($lineas[$i],$donde);
   }
}

sub modo   # Cambio/consulta de modo (comando o juego)
{
  my $cad_modo=$_[0];
  my $donde=$_[1];

  if ($cad_modo eq '')
  {
    if ($modo_comando) { $con->enviar_mensaje('--Modo comando--',$donde); }
    else { $con->enviar_mensaje('--Modo juego--',$donde); }
  }
  elsif ($cad_modo eq 'comando')
  {
    $modo_comando=1;
    log::eslog('Modo comando');
    $con->enviar_mensaje('--Modo comando--',$donde);
  }
  elsif ($cad_modo eq 'juego')
  {
    $modo_comando=0;
    log::eslog('Modo juego');
    $con->enviar_mensaje('--Modo juego--',$donde);
  }
  else { log::eslog('Modo errneo, no cambiado.'); }
}


my @txt_ini=split("\n",$texto_inicial);
log::eslog($txt_ini[0]);
log::eslog("Usando mdulo de protocolo '$con'");
log::eslog($con.': '.$con->texto_inicial());
$con->configurar();
$con->conectar();

END
{
  unlink("$d_tmp/tmp_$$");
  unlink("$d_tmp/err_$$");
  log::eslog('Finalizando');
}
