/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.AbstractIndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HTMLDocument
extends AbstractIndexableDocument
implements ParsableDocument {
    private String MIMETYPE = "text/html";
    protected File tidyConf = null;

    public HTMLDocument(String id) throws SDXException {
        this.setId(id);
    }

    public HTMLDocument() {
    }

    public void startIndexing(SAXParser parser, XMLConsumer consumer) throws SDXException {
        Utilities.checkXmlConsumer(super.getLog(), consumer);
        super.resetFields();
        this.parse(parser, consumer);
    }

    public void parse(SAXParser parser) throws SDXException {
        this.parse(parser, this.xmlConsumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(SAXParser parser, XMLConsumer consumer) throws SDXException {
        if (parser == null) {
            String[] args = new String[1];
            if (this.getURL() == null) throw new SDXException(super.getLog(), 5100, args, null);
            args[0] = this.getURL().toExternalForm();
            throw new SDXException(super.getLog(), 5100, args, null);
        }
        Utilities.checkXmlConsumer(super.getLog(), consumer);
        StringWriter stringWriter = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(stringWriter);
        try {
            try {
                Tidy tidy = new Tidy();
                tidy.setXmlOut(true);
                tidy.setXHTML(true);
                tidy.setTidyMark(false);
                tidy.setXmlPi(true);
                tidy.setXmlPIs(true);
                tidy.setNumEntities(true);
                tidy.setDocType("omit");
                tidy.setBreakBeforeBR(true);
                tidy.setFixComments(true);
                tidy.setBreakBeforeBR(true);
                if (super.getLog() != null) {
                    tidy.setShowWarnings(super.getLog().isWarnEnabled());
                    tidy.setQuiet(!super.getLog().isInfoEnabled());
                }
                if (this.tidyConf != null && this.tidyConf.canRead()) {
                    tidy.setConfigurationFromFile(this.tidyConf.getCanonicalPath());
                }
                tidy.setErrout(errorWriter);
                Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(this.openStream()), null);
                XMLUtils.stripDuplicateAttributes((Node)doc, null);
                DOMStreamer streamer = new DOMStreamer(consumer);
                streamer.stream((Node)doc);
            }
            catch (SAXException e) {
                String[] args = new String[2];
                if (this.getURL() != null) {
                    args[0] = this.getURL().toExternalForm();
                }
                args[1] = e.getMessage();
                throw new SDXException(super.getLog(), 5101, args, e);
            }
            catch (IOException e) {
                String[] args = new String[2];
                if (this.getURL() != null) {
                    args[0] = this.getURL().toExternalForm();
                }
                args[1] = e.getMessage();
                throw new SDXException(super.getLog(), 5101, args, e);
            }
            Object var9_13 = null;
            errorWriter.flush();
            errorWriter.close();
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            errorWriter.flush();
            errorWriter.close();
            if (super.getLog() == null) throw throwable;
            if (!super.getLog().isWarnEnabled()) throw throwable;
            super.getLog().warn(stringWriter.toString());
            throw throwable;
        }
        if (super.getLog() == null) return;
        if (!super.getLog().isWarnEnabled()) return;
        super.getLog().warn(stringWriter.toString());
    }

    public String getDocType() {
        return "html";
    }

    public void setTransformedDocument(byte[] content) throws SDXException {
        if (content == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 5102, args, null);
        }
        HTMLDocument doc = new HTMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(super.getLog());
        this.transformedDoc.setContent(content);
        this.setUpTransformedDocument();
    }

    public void setTransformedDocument(File file) throws SDXException {
        if (file == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 5102, args, null);
        }
        HTMLDocument doc = new HTMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(super.getLog());
        this.transformedDoc.setContent(file);
        this.setUpTransformedDocument();
    }

    public String getMimeType() {
        return this.MIMETYPE;
    }

    public void setTidyConfiguration(File tidyConf) {
        this.tidyConf = tidyConf;
    }

    public void addAdditionalSystemFields(org.apache.lucene.document.Document doc) {
    }
}

