/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Utilities;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class OAIDocument
extends XMLDocument
implements OAIObject {
    private String dateString = null;
    private String identifier = null;
    public static final String INTERNAL_FIELD_NAME_SDXOAIDATE = "sdxoaidate";
    public static final String INTERNAL_FIELD_NAME_SDXOAIID = "sdxoaiid";

    public void addAdditionalSystemFields(Document doc) {
        Field idField;
        if (Utilities.checkString(this.dateString)) {
            Date myDate = null;
            TimeZone gmtZone = TimeZone.getTimeZone("GMT");
            try {
                SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
                _sdf.setTimeZone(gmtZone);
                myDate = _sdf.parse(this.dateString);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd");
                    _sdf.setTimeZone(gmtZone);
                    myDate = _sdf.parse(this.dateString);
                }
                catch (ParseException ee) {
                    ee.printStackTrace();
                }
            }
            if (myDate != null) {
                long oaidate = myDate.getTime();
                Field dateField = new Field(INTERNAL_FIELD_NAME_SDXOAIDATE, DateField.timeToString(oaidate), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO);
                if (dateField != null) {
                    doc.add((Fieldable)dateField);
                }
            } else {
                String message = "Impossible de parser la date " + this.dateString + " du document OAI " + this.identifier;
                OAIUtilities.logError(this._logger, message, null);
            }
        }
        if (Utilities.checkString(this.identifier) && (idField = new Field(INTERNAL_FIELD_NAME_SDXOAIID, this.identifier, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO)) != null) {
            doc.add((Fieldable)idField);
        }
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

