/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.AbstractPool;
import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.pool.Resizable;
import org.apache.avalon.framework.activity.Disposable;

public class DefaultPool
extends AbstractPool
implements Disposable {
    protected int m_min;
    protected int m_max;
    protected PoolController m_controller;
    protected boolean m_disposed = false;
    protected boolean m_quickFail = false;

    public DefaultPool(ObjectFactory factory, PoolController controller) throws Exception {
        this(factory, controller, 8, 8);
    }

    public DefaultPool(ObjectFactory factory, PoolController controller, int initial, int maximum) throws Exception {
        super(factory);
        int t_max = maximum;
        int t_min = initial;
        if (t_min < 0) {
            if (null != this.getLogger() && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Minumum number of poolables specified is less than 0, using 0");
            }
            t_min = 0;
        }
        if (t_max < t_min || t_max < 1) {
            if (null != this.getLogger() && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Maximum number of poolables specified must be at least 1 and must be greater than the minumum number of connections");
            }
            t_max = t_min > 1 ? t_min : 1;
        }
        this.m_max = t_max;
        this.m_min = t_min;
        this.m_controller = null != controller ? controller : new DefaultPoolController(t_min / 2);
    }

    public DefaultPool(ObjectFactory factory) throws Exception {
        this(factory, null, 8, 8);
    }

    public DefaultPool(Class clazz, int initial, int maximum) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), null, initial, maximum);
    }

    public DefaultPool(Class clazz, int initial) throws NoSuchMethodException, Exception {
        this(clazz, initial, initial);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Poolable get() throws Exception {
        Poolable obj = null;
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a Poolable before the pool is initialized");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a Poolable after the pool is disposed");
        }
        try {
            this.m_mutex.acquire();
            if (this.m_ready.size() == 0) {
                if (this instanceof Resizable) {
                    this.internalGrow(this.m_controller.grow());
                    if (this.m_ready.size() <= 0) throw new Exception("Could not create enough Components to service your request.");
                    obj = (Poolable)this.m_ready.remove();
                } else {
                    obj = this.newPoolable();
                }
            } else {
                obj = (Poolable)this.m_ready.remove();
            }
            this.m_active.add(obj);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Retrieving a " + this.m_factory.getCreatedClass().getName() + " from the pool");
            }
            Poolable poolable = obj;
            Object var4_3 = null;
            this.m_mutex.release();
            return poolable;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.release();
            throw throwable;
        }
    }

    public void put(Poolable obj) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a Poolable before the pool is initialized");
        }
        try {
            block10: {
                try {
                    if (obj instanceof Recyclable) {
                        ((Recyclable)obj).recycle();
                    }
                    this.m_mutex.acquire();
                    this.m_active.remove(this.m_active.indexOf(obj));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Returning a " + this.m_factory.getCreatedClass().getName() + " to the pool");
                    }
                    if (!this.m_disposed) {
                        this.m_ready.add((Object)obj);
                        if (this.size() > this.m_max && this instanceof Resizable) {
                            this.internalShrink(this.m_controller.shrink());
                        }
                        break block10;
                    }
                    this.removePoolable(obj);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Pool interrupted while waiting for lock.", (Throwable)e);
                    }
                    Object var4_3 = null;
                    this.m_mutex.release();
                }
            }
            Object var4_2 = null;
            this.m_mutex.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.release();
            throw throwable;
        }
    }

    public final void dispose() {
        try {
            try {
                this.m_mutex.acquire();
                while (this.m_ready.size() > 0) {
                    this.removePoolable((Poolable)this.m_ready.remove());
                }
            }
            catch (Exception e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Caught an exception disposing of pool", (Throwable)e);
                }
                Object var3_2 = null;
                this.m_mutex.release();
            }
            Object var3_1 = null;
            this.m_mutex.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_disposed = true;
    }
}

