/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;

public class LocationPath
extends Path {
    private boolean absolute;

    public LocationPath(boolean absolute, Step[] steps) {
        super(20, steps);
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean computeContextDependent() {
        if (!this.absolute) {
            return true;
        }
        return super.computeContextDependent();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(PATH");
        if (this.absolute) {
            buffer.append("[absolute] ");
        } else {
            buffer.append("[relative] ");
        }
        Step[] args = this.getSteps();
        if (args != null) {
            buffer.append(' ');
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object compute(EvalContext context) {
        EvalContext rootContext = this.isAbsolute() ? context.getRootContext() : context;
        return this.evalSteps(new InitialContext(rootContext));
    }

    public Object computeValue(EvalContext context) {
        EvalContext rootContext = this.isAbsolute() ? context.getRootContext() : context;
        return this.getSingleNodePointerForSteps(new InitialContext(rootContext));
    }
}

