/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.beans.PropertyDescriptor;
import java.util.Locale;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class BeanPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private JXPathBeanInfo beanInfo;
    private PropertyDescriptor[] propertyDescriptors;
    private String[] names;

    public BeanPointer(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public BeanPointer(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public PropertyPointer getPropertyPointer() {
        return new BeanPropertyPointer((NodePointer)this, this.beanInfo);
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.bean;
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (!(this.parent instanceof PropertyPointer)) {
            throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
        }
        this.parent.setValue(value);
    }

    public void remove() {
        super.setValue(null);
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove an object that is not some other object's property or a collection element");
        }
        this.parent.remove();
    }

    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        int i_other;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BeanPointer)) {
            return false;
        }
        BeanPointer other = (BeanPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        int i_this = this.index == NodePointer.WHOLE_COLLECTION ? 0 : this.index;
        int n = i_other = other.index == NodePointer.WHOLE_COLLECTION ? 0 : other.index;
        if (i_this != i_other) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + this.bean + "'";
        }
        return "";
    }
}

