/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.DynamicPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class DynamicPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private DynamicPropertyHandler handler;
    private String[] names;

    public DynamicPointer(QName name, Object bean, DynamicPropertyHandler handler, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.handler = handler;
    }

    public DynamicPointer(NodePointer parent, QName name, Object bean, DynamicPropertyHandler handler) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.handler = handler;
    }

    public PropertyPointer getPropertyPointer() {
        return new DynamicPropertyPointer((NodePointer)this, this.handler);
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.bean;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot replace the root object");
    }

    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        return "";
    }

    public int hashCode() {
        return System.identityHashCode(this.bean) + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynamicPointer)) {
            return false;
        }
        DynamicPointer other = (DynamicPointer)object;
        return this.bean == other.bean && this.name.equals(other.name);
    }
}

