/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import java.util.Date;
import java.util.GregorianCalendar;
import org.relaxng.datatype.ValidationContext;

class DateTimeDatatype
extends RegexDatatype
implements OrderRelation {
    private static final String YEAR_PATTERN = "-?([1-9][0-9]*)?[0-9]{4}";
    private static final String MONTH_PATTERN = "[0-9]{2}";
    private static final String DAY_OF_MONTH_PATTERN = "[0-9]{2}";
    private static final String TIME_PATTERN = "[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]*)?";
    private static final String TZ_PATTERN = "(Z|[+\\-][0-9][0-9]:[0-5][0-9])?";
    private final String template;
    private static final int TIME_ZONE_MAX = 50400000;

    DateTimeDatatype(String string) {
        super(DateTimeDatatype.makePattern(string));
        this.template = string;
    }

    private static String makePattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case 'Y': {
                    stringBuffer.append(YEAR_PATTERN);
                    break;
                }
                case 'M': {
                    stringBuffer.append("[0-9]{2}");
                    break;
                }
                case 'D': {
                    stringBuffer.append("[0-9]{2}");
                    break;
                }
                case 't': {
                    stringBuffer.append(TIME_PATTERN);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        stringBuffer.append(TZ_PATTERN);
        return stringBuffer.toString();
    }

    boolean allowsValue(String string, ValidationContext validationContext) {
        return this.getValue(string, validationContext) != null;
    }

    Object getValue(String string, ValidationContext validationContext) {
        int numberFormatException;
        int n;
        boolean bl2 = false;
        int n3 = 2000;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = string.length();
        int n12 = 0;
        int n13 = this.template.length();
        while (n12 < n13) {
            char bl = this.template.charAt(n12);
            switch (bl) {
                case 'Y': {
                    bl2 = string.charAt(n10) == '-';
                    n = bl2 ? n10 + 1 : n10;
                    n10 = DateTimeDatatype.skipDigits(string, n);
                    try {
                        n3 = Integer.parseInt(string.substring(n, n10));
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return null;
                    }
                }
                case 'M': {
                    n4 = DateTimeDatatype.parse2Digits(string, n10);
                    n10 += 2;
                    break;
                }
                case 'D': {
                    n5 = DateTimeDatatype.parse2Digits(string, n10);
                    n10 += 2;
                    break;
                }
                case 't': {
                    n6 = DateTimeDatatype.parse2Digits(string, n10);
                    n7 = DateTimeDatatype.parse2Digits(string, n10 += 3);
                    n8 = DateTimeDatatype.parse2Digits(string, n10 += 3);
                    if ((n10 += 2) >= n11 || string.charAt(n10) != '.') break;
                    numberFormatException = DateTimeDatatype.skipDigits(string, ++n10);
                    int gregorianCalendar = 0;
                    while (gregorianCalendar < 3) {
                        n9 *= 10;
                        if (n10 < numberFormatException) {
                            n9 += string.charAt(n10++) - 48;
                        }
                        ++gregorianCalendar;
                    }
                    n10 = numberFormatException;
                    break;
                }
                default: {
                    ++n10;
                }
            }
            ++n12;
        }
        boolean bl = n10 < n11;
        n = bl && string.charAt(n10) != 'Z' ? DateTimeDatatype.parseTimeZone(string, n10) : 0;
        if (n8 == 60) {
            numberFormatException = n9 + 1;
            n9 = 999;
            n8 = 59;
        } else {
            numberFormatException = 0;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setLenient(false);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.clear();
        gregorianCalendar.set(15, n);
        gregorianCalendar.set(16, 0);
        gregorianCalendar.set(0, bl2 ? 0 : 1);
        gregorianCalendar.set(n3, n4 - 1, n5, n6, n7, n8);
        gregorianCalendar.set(14, n9);
        try {
            return new DateTime(gregorianCalendar.getTime(), numberFormatException, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static int parseTimeZone(String string, int n) {
        int n2 = string.charAt(n) == '-' ? -1 : 1;
        return (Integer.parseInt(string.substring(n + 1, n + 3)) * 60 + Integer.parseInt(string.substring(n + 4))) * 60 * 1000 * n2;
    }

    private static int parse2Digits(String string, int n) {
        return (string.charAt(n) - 48) * 10 + (string.charAt(n + 1) - 48);
    }

    private static int skipDigits(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if ("0123456789".indexOf(string.charAt(n)) < 0) break;
            ++n;
        }
        return n;
    }

    OrderRelation getOrderRelation() {
        return this;
    }

    public boolean isLessThan(Object object, Object object2) {
        DateTime dateTime = (DateTime)object;
        DateTime dateTime2 = (DateTime)object2;
        long l = dateTime.getDate().getTime();
        long l2 = dateTime2.getDate().getTime();
        if (dateTime.getHasTimeZone() == dateTime2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(l, dateTime.getLeapMilliseconds(), l2, dateTime2.getLeapMilliseconds());
        }
        if (!dateTime2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(l, dateTime.getLeapMilliseconds(), l2 - 50400000L, dateTime2.getLeapMilliseconds());
        }
        return DateTimeDatatype.isLessThan(l + 50400000L, dateTime.getLeapMilliseconds(), l2, dateTime2.getLeapMilliseconds());
    }

    private static boolean isLessThan(long l, int n, long l2, int n2) {
        if (l < l2) {
            return true;
        }
        if (l > l2) {
            return false;
        }
        return n < n2;
    }

    private static class DateTime {
        private final Date date;
        private final int leapMilliseconds;
        private final boolean hasTimeZone;

        DateTime(Date date, int n, boolean bl) {
            this.date = date;
            this.leapMilliseconds = n;
            this.hasTimeZone = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DateTime)) {
                return false;
            }
            DateTime dateTime = (DateTime)object;
            return this.date.equals(dateTime.date) && this.leapMilliseconds == dateTime.leapMilliseconds && this.hasTimeZone == dateTime.hasTimeZone;
        }

        public int hashCode() {
            return this.date.hashCode();
        }

        Date getDate() {
            return this.date;
        }

        int getLeapMilliseconds() {
            return this.leapMilliseconds;
        }

        boolean getHasTimeZone() {
            return this.hasTimeZone;
        }
    }
}

