/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.util.Code;
import org.mortbay.util.URI;

public class FormAuthenticator
implements SecurityConstraint.Authenticator {
    public static final String __J_URI = "org.mortbay.jetty.URI";
    public static final String __J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    public static final String __J_SECURITY_CHECK = "j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formLoginPage;

    public String getAuthMethod() {
        return "FORM";
    }

    public void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            Code.warning("form-login-page must start with /");
            path = "/" + path;
        }
        this._formLoginPage = path;
    }

    public String getLoginPage() {
        return this._formLoginPage;
    }

    public void setErrorPage(String path) {
        if (!path.startsWith("/")) {
            Code.warning("form-error-page must start with /");
            path = "/" + path;
        }
        this._formErrorPage = path;
    }

    public String getErrorPage() {
        return this._formErrorPage;
    }

    public UserPrincipal authenticated(UserRealm realm, String pathInContext, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
        HttpServletResponse response = (HttpServletResponse)httpResponse.getWrapper();
        String uri = pathInContext;
        HttpSession session = request.getSession(true);
        if (uri.substring(uri.lastIndexOf("/") + 1).startsWith(__J_SECURITY_CHECK)) {
            String username = request.getParameter(__J_USERNAME);
            String password = request.getParameter(__J_PASSWORD);
            UserPrincipal user = realm.authenticate(username, password, httpRequest);
            String nuri = (String)session.getAttribute(__J_URI);
            session.removeAttribute(__J_URI);
            if (nuri == null || nuri.length() == 0) {
                nuri = "/";
            }
            if (user != null) {
                Code.debug((Object)"Form authentication OK for ", (Object)username);
                httpRequest.setAuthType("FORM");
                httpRequest.setAuthUser(username);
                httpRequest.setUserPrincipal(user);
                session.setAttribute(__J_AUTHENTICATED, (Object)user);
                response.sendRedirect(response.encodeRedirectURL(nuri));
            } else {
                Code.debug((Object)"Form authentication FAILED for ", (Object)username);
                if (this._formErrorPage != null) {
                    response.sendRedirect(response.encodeRedirectURL(URI.addPaths(request.getContextPath(), this._formErrorPage)));
                } else {
                    response.sendError(403);
                }
            }
            return null;
        }
        UserPrincipal user = (UserPrincipal)session.getAttribute(__J_AUTHENTICATED);
        if (user != null && user.isAuthenticated()) {
            Code.debug((Object)"FORM Authenticated for ", (Object)user.getName());
            httpRequest.setAuthType("FORM");
            httpRequest.setAuthUser(user.getName());
            httpRequest.setUserPrincipal(user);
            return user;
        }
        if (pathInContext != null && pathInContext.equals(this._formErrorPage) || pathInContext.equals(this._formLoginPage)) {
            return SecurityConstraint.__NOBODY;
        }
        if (httpRequest.getQuery() != null) {
            uri = uri + "?" + httpRequest.getQuery();
        }
        session.setAttribute(__J_URI, (Object)(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URI.addPaths(request.getContextPath(), uri)));
        response.sendRedirect(response.encodeRedirectURL(URI.addPaths(request.getContextPath(), this._formLoginPage)));
        return null;
    }
}

