/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.StringTokenizer;
import org.mortbay.util.Code;
import org.mortbay.util.Frame;
import org.mortbay.util.Loader;
import org.mortbay.util.LogSink;

public class Log {
    public static final String DEBUG = "DEBUG  ";
    public static final String EVENT = "EVENT  ";
    public static final String WARN = "WARN!! ";
    public static final String ASSERT = "ASSERT ";
    public static final String FAIL = "FAIL!! ";
    public LogSink[] _sinks = null;
    public String _logOptions = null;
    private boolean _initialized = false;
    static /* synthetic */ Class class$org$mortbay$util$LogSink;

    public static Log instance() {
        return Singleton.__instance;
    }

    private synchronized void defaultInit() {
        if (!this._initialized) {
            this._initialized = true;
            this._logOptions = System.getProperty("LOG_OPTIONS", Code.getDebug() ? "stLT" : "tT");
            String sinkClasses = System.getProperty("LOG_CLASSES", "org.mortbay.util.OutputStreamLogSink");
            StringTokenizer sinkTokens = new StringTokenizer(sinkClasses, ";");
            LogSink sink = null;
            while (sinkTokens.hasMoreTokens()) {
                String sinkClassName = sinkTokens.nextToken();
                try {
                    Class sinkClass = Loader.loadClass(this.getClass(), sinkClassName);
                    if ((class$org$mortbay$util$LogSink == null ? Log.class$("org.mortbay.util.LogSink") : class$org$mortbay$util$LogSink).isAssignableFrom(sinkClass)) {
                        sink = (LogSink)sinkClass.newInstance();
                        sink.setOptions(this._logOptions);
                        sink.start();
                        Singleton.__instance.add(sink);
                        continue;
                    }
                    System.err.println(sinkClass + " is not a org.mortbay.util.LogSink");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Log() {
    }

    public synchronized void add(String logSinkClass) {
        try {
            if (logSinkClass == null || logSinkClass.length() == 0) {
                logSinkClass = "org.mortbay.util.OutputStreamLogSink";
            }
            Class sinkClass = Loader.loadClass(this.getClass(), logSinkClass);
            LogSink sink = (LogSink)sinkClass.newInstance();
            this.add(sink);
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void add(LogSink logSink) {
        if (this._sinks == null) {
            this._sinks = new LogSink[1];
            this._sinks[0] = logSink;
        } else {
            boolean slotFree = false;
            int i = this._sinks.length;
            while (i-- > 0) {
                if (this._sinks[i] != null) continue;
                slotFree = true;
                this._sinks[i] = logSink;
                break;
            }
            if (!slotFree) {
                LogSink[] ns = new LogSink[this._sinks.length + 1];
                int i2 = this._sinks.length;
                while (i2-- > 0) {
                    ns[i2] = this._sinks[i2];
                }
                ns[this._sinks.length] = logSink;
                this._sinks = ns;
            }
        }
        this._initialized = true;
    }

    public LogSink[] getLogSinks() {
        return this._sinks;
    }

    public synchronized void deleteStoppedLogSinks() {
        if (this._sinks != null) {
            int s = this._sinks.length;
            while (s-- > 0) {
                if (this._sinks[s] == null || this._sinks[s].isStarted()) continue;
                this._sinks[s] = null;
            }
        }
    }

    public synchronized void disableLog() {
        if (this._sinks != null) {
            int s = this._sinks.length;
            while (s-- > 0) {
                try {
                    if (this._sinks[s] == null) continue;
                    this._sinks[s].stop();
                }
                catch (InterruptedException e) {
                    Code.ignore(e);
                }
            }
            this._sinks = null;
        }
        this._initialized = true;
    }

    public static void message(String tag, Object msg, Frame frame) {
        long time = System.currentTimeMillis();
        Log.instance().message(tag, msg, frame, time);
    }

    public static void event(Object message, int stackDepth) {
        Log.message(EVENT, message, new Frame(stackDepth));
    }

    public static void event(Object message) {
        Log.message(EVENT, message, new Frame(1));
    }

    public static void warning(Object message, int stackDepth) {
        Log.message(WARN, message, new Frame(1));
    }

    public static void warning(Object message) {
        Log.message(WARN, message, new Frame(1));
    }

    public synchronized void message(String tag, Object msg, Frame frame, long time) {
        if (!this._initialized) {
            this.defaultInit();
        }
        if (this._sinks == null) {
            System.err.println(time + ": " + tag + "," + msg + "," + frame);
            return;
        }
        boolean logged = false;
        int s = this._sinks.length;
        while (s-- > 0) {
            if (this._sinks[s] == null || !this._sinks[s].isStarted()) continue;
            logged = true;
            this._sinks[s].log(tag, msg, frame, time);
        }
        if (!logged) {
            System.err.println(time + ": " + tag + "," + msg + "," + frame);
        }
    }

    public synchronized void message(String tag, String msg) {
        this.message(tag, msg, new Frame(1), System.currentTimeMillis());
    }

    public synchronized void setOptions(String logOptions) {
        this._logOptions = logOptions;
        int s = this._sinks.length;
        while (s-- > 0) {
            if (this._sinks[s] == null) continue;
            this._sinks[s].setOptions(logOptions);
        }
    }

    public String getOptions() {
        return this._logOptions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Singleton {
        static final Log __instance = new Log();

        private Singleton() {
        }
    }
}

