/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class BaseTest
extends TestCase
implements RDFErrorHandler {
    private String xmlBase;
    private InputStream in;
    Model model;

    public BaseTest(String string, InputStream inputStream) {
        super(string);
        this.in = inputStream;
        this.xmlBase = string;
    }

    protected abstract void runTest();

    void loadRDF() throws IOException, RDFException {
        this.model = new ModelMem();
        JenaReader jenaReader = new JenaReader();
        jenaReader.setErrorHandler(this);
        jenaReader.setProperty("error-mode", "strict");
        jenaReader.read(this.model, this.in, this.xmlBase);
        this.in.close();
    }

    public void warning(Exception exception) {
        this.error(0, exception);
    }

    public void error(Exception exception) {
        this.error(1, exception);
    }

    public void fatalError(Exception exception) {
        this.error(2, exception);
    }

    private void error(int n, Exception exception) {
        if (exception instanceof ParseException) {
            this.onError(((ParseException)exception).getErrorNumber());
        } else if (exception instanceof SAXParseException) {
            this.onError(111);
        } else if (exception instanceof SAXException) {
            Assert.fail((String)("Not expecting a SAXException: " + exception.getMessage()));
        } else {
            Assert.fail((String)("Not expecting an Exception: " + exception.getMessage()));
        }
    }

    void onError(int n) {
        Assert.fail((String)("Parser reports unexpected error: " + n));
    }
}

