/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ContainerI;
import com.hp.hpl.mesa.rdf.jena.model.ClosableIterator;
import com.hp.hpl.mesa.rdf.jena.model.Container;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ContNodeIteratorImpl
implements NodeIterator {
    Iterator iterator;
    Object object;
    Statement stmt = null;
    Container cont;
    int size;
    int index = 0;
    int numDeleted = 0;
    Vector moved = new Vector();

    public ContNodeIteratorImpl(Iterator iterator, Object object, Container container) throws RDFException {
        this.iterator = iterator;
        this.object = object;
        this.cont = container;
        this.size = container.size();
    }

    public boolean hasNext() throws RDFException {
        return this.iterator.hasNext();
    }

    public RDFNode next() throws NoSuchElementException, RDFException {
        if (this.iterator != null) {
            this.stmt = (Statement)this.iterator.next();
            ++this.index;
            return this.stmt.getObject();
        }
        throw new RDFException(8);
    }

    public void remove() throws NoSuchElementException, RDFException {
        if (this.stmt == null) {
            throw new NoSuchElementException();
        }
        this.iterator.remove();
        if (this.index > this.size - this.numDeleted) {
            ((ContainerI)((Object)this.cont)).remove((Integer)this.moved.elementAt(this.size - this.index), this.stmt.getObject());
        } else {
            this.cont.remove(this.stmt);
            this.moved.add(new Integer(this.index));
        }
        this.stmt = null;
        ++this.numDeleted;
    }

    public void close() throws RDFException {
        if (this.iterator instanceof ClosableIterator) {
            ((ClosableIterator)this.iterator).close();
        }
        this.iterator = null;
        this.object = null;
    }
}

