/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.prettywriter;

import com.hp.hpl.mesa.rdf.jena.common.Util;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.ArrayIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.ArrayMap;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.DAML;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Filter;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.FilterIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.FilterResIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.FilterStmtIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.IteratorIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.LateBindingIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Map1;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Map1Iterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.NullIterator;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.PrettyWriter;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.Relation;
import com.hp.hpl.mesa.rdf.jena.common.prettywriter.RuntimeRDFException;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RSS;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

class Unparser {
    private static final String rdfns = RDF.type.getNameSpace();
    private static final Integer one = new Integer(1);
    private Relation nameSpaces;
    private String localName;
    private Map objectTable;
    private Model model;
    private PrintWriter out;
    private Set doing = new HashSet();
    private Set doneSet = new HashSet();
    private Set haveReified = new HashSet();
    private Resource[] pleasingTypes = null;
    private Set pleasingTypeSet = new HashSet();
    private final PrettyWriter prettyWriter;
    private boolean avoidExplicitReification = true;
    Map res2statement;
    Map statement2res;
    private Set idDone = new HashSet();
    int[] codeCoverage = new int[8];
    private int indentLevel = 0;
    private int currentColumn = 0;
    private static Map specialPrefixes = new HashMap();
    private int genSym;
    private Map localNameMap = new HashMap();
    private int localId = 1;
    private Set infinite;
    private Set openResIterators = new HashSet();

    Unparser(PrettyWriter prettyWriter, String string, Model model, PrintWriter printWriter) throws RDFException {
        Statement statement;
        RDFNode rDFNode;
        Object object;
        this.localName = string;
        this.prettyWriter = prettyWriter;
        this.out = printWriter;
        this.model = model;
        this.nameSpaces = this.listNameSpaces();
        this.objectTable = new HashMap();
        StmtIterator stmtIterator = model.listStatements();
        try {
            while (stmtIterator.hasNext()) {
                object = stmtIterator.next();
                rDFNode = object.getObject();
                if (!(rDFNode instanceof Resource)) continue;
                this.increaseObjectCount((Resource)rDFNode);
            }
            statement = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        try {
            this.res2statement = new HashMap();
            this.statement2res = new HashMap();
            object = new FilterResIterator(new Filter(){

                public boolean accept(Object object) {
                    Resource resource = (Resource)object;
                    try {
                        return resource.hasProperty(RDF.subject) && resource.hasProperty(RDF.object) && resource.hasProperty(RDF.predicate);
                    }
                    catch (RDFException rDFException) {
                        throw new RuntimeRDFException(rDFException);
                    }
                }
            }, this.model.listSubjectsWithProperty(RDF.type, RDF.Statement));
            while (object.hasNext()) {
                rDFNode = object.next();
                try {
                    Statement statement2 = rDFNode.getProperty(RDF.subject);
                    statement = rDFNode.getProperty(RDF.predicate);
                    Statement statement3 = rDFNode.getProperty(RDF.object);
                    RDFNode rDFNode2 = statement3.getObject();
                    Resource resource = (Resource)statement2.getObject();
                    Resource resource2 = (Resource)statement.getObject();
                    Property property = this.model.createProperty(resource2.getURI());
                    Statement statement4 = this.model.createStatement(resource, property, rDFNode2);
                    this.res2statement.put(rDFNode, statement4);
                    this.statement2res.put(statement4, rDFNode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
    }

    void write() throws RDFException {
        this.wRDF();
    }

    void useNameSpaceDecl(String[][] stringArray) {
        this.useNameSpaceDecl(new ArrayMap(stringArray));
    }

    void useNameSpaceDecl(Map map) {
        String string;
        String string2;
        map.remove("rdf");
        map.remove("RDF");
        map.remove("xml");
        map.remove("XML");
        Iterator iterator = map.entrySet().iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            string2 = (String)entry.getValue();
            if (this.nameSpaces.forward(string2) == null && !hashSet.contains(string2)) continue;
            string = (String)entry.getKey();
            Set set = this.nameSpaces.backward(string);
            if (set != null) {
                hashSet.addAll(set);
            }
            this.nameSpaces.set11(string2, string);
            hashSet.remove(string2);
        }
        iterator = hashSet.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            string2 = (String)((Object)iterator.next());
            while (this.nameSpaces.backward(string = "RDFNsId" + n++) != null) {
            }
            this.nameSpaces.set(string2, string);
        }
    }

    void setTopLevelTypes(Resource[] resourceArray) {
        this.pleasingTypes = resourceArray;
        this.pleasingTypeSet = new HashSet<Resource>(Arrays.asList(resourceArray));
    }

    private void wRDF() throws RDFException {
        this.tab();
        this.print("<?xml version='1.0'?>");
        this.tab();
        this.print("<");
        this.wQname(rdfns, "RDF");
        this.indentPlus();
        this.printNameSpaceDefn();
        this.print(">");
        this.wObjStar();
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wQname(rdfns, "RDF");
        this.print(">");
        this.tab();
    }

    private void wObjStar() throws RDFException {
        try {
            Iterator iterator = this.listSubjects();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                this.increaseObjectCount(resource);
                this.wObj(resource, true);
            }
            this.closeAllResIterators();
        }
        catch (RuntimeRDFException runtimeRDFException) {
            throw runtimeRDFException.getUnderlyingException();
        }
    }

    private boolean wPropertyElt(Statement statement, RDFNode rDFNode) throws RDFException {
        return this.wPropertyEltCompact(statement, rDFNode) || this.wPropertyEltDamlCollection(statement, rDFNode) || this.wPropertyEltLiteral(statement, rDFNode) || this.wPropertyEltResource(statement, rDFNode) || this.wPropertyEltValue(statement, rDFNode);
    }

    private boolean wPropertyEltCompact(Statement statement, RDFNode rDFNode) throws RDFException {
        if (!(rDFNode instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.allPropsAreAttr(resource) && !this.doing.contains(resource)) {
            return false;
        }
        if (!this.hasProperties(resource) && this.isGenuineAnon(resource)) {
            return false;
        }
        if (this.wantReification(statement)) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        this.wPropName(statement);
        this.indentPlus();
        this.wIdRefAttrOpt(statement, resource);
        if (!this.doing.contains(resource)) {
            this.wBagIdAttrOpt(resource);
            this.wPropAttrAll(resource);
        } else if (this.isGenuineAnon(resource)) {
            this.error("Genuine anon resource in cycle?");
        }
        this.indentMinus();
        this.print("/>");
        return true;
    }

    private boolean wPropertyEltLiteral(Statement statement, RDFNode rDFNode) throws RDFException {
        if (!(rDFNode instanceof Literal) || !((Literal)rDFNode).getWellFormed()) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        this.wPropName(statement);
        this.wIdAttrReified(statement);
        this.wParseLiteral();
        this.print(">");
        this.print(rDFNode.toString());
        this.print("</");
        this.wPropName(statement);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltResource(Statement statement, RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Literal) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!this.isGenuineAnon(resource)) {
            return false;
        }
        if (this.getType(resource) != null) {
            return false;
        }
        this.done(statement);
        this.tab();
        this.print("<");
        this.wPropName(statement);
        this.indentPlus();
        this.wIdAttrReified(statement);
        this.wParseResource();
        this.print(">");
        this.wPropertyEltStar(resource);
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wPropName(statement);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltValue(Statement statement, RDFNode rDFNode) throws RDFException {
        return this.wPropertyEltValueString(statement, rDFNode) || this.wPropertyEltValueObj(statement, rDFNode);
    }

    private boolean wPropertyEltValueString(Statement statement, RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Literal) {
            this.done(statement);
            Literal literal = (Literal)rDFNode;
            String string = literal.getLanguage();
            this.tab();
            this.print("<");
            this.wPropName(statement);
            this.wIdAttrReified(statement);
            if (string != null && string.length() > 0) {
                this.print(" xml:lang=" + this.quote(string));
            }
            this.print(">");
            this.wValueString(literal);
            this.print("</");
            this.wPropName(statement);
            this.print(">");
            return true;
        }
        return false;
    }

    private void wValueString(Literal literal) throws RDFException {
        String string = literal.getString();
        this.print(Util.substituteStandardEntities(string));
    }

    private boolean wPropertyEltValueObj(Statement statement, RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            this.done(statement);
            this.tab();
            this.print("<");
            this.wPropName(statement);
            this.wIdAttrReified(statement);
            this.print(">");
            this.tab();
            this.indentPlus();
            this.wObj(resource, false);
            this.indentMinus();
            this.tab();
            this.print("</");
            this.wPropName(statement);
            this.print(">");
            return true;
        }
        return false;
    }

    private boolean wPropertyEltDamlCollection(Statement statement, RDFNode rDFNode) throws RDFException {
        Statement[][] statementArray = this.getDamlList(rDFNode);
        if (statementArray == null) {
            return false;
        }
        this.done(statement);
        int n = 0;
        while (n < statementArray.length) {
            this.done(statementArray[n][0]);
            this.done(statementArray[n][1]);
            this.done(statementArray[n][2]);
            ++n;
        }
        this.tab();
        this.print("<");
        this.wPropName(statement);
        this.indentPlus();
        this.wIdAttrReified(statement);
        this.wParseDamlCollection();
        this.print(">");
        int n2 = 0;
        while (n2 < statementArray.length) {
            this.wObj((Resource)statementArray[n2][0].getObject(), false);
            ++n2;
        }
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wPropName(statement);
        this.print(">");
        return true;
    }

    private void wPropAttrAll(Resource resource) throws RDFException {
        this.wPropAttrSome(resource);
        if (this.hasProperties(resource)) {
            this.error("Bad call to wPropAttrAll");
        }
    }

    private void wPropAttrSome(Resource resource) throws RDFException {
        StmtIterator stmtIterator = this.listProperties(resource);
        try {
            HashSet hashSet = new HashSet();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                RDFNode rDFNode = statement.getObject();
                if (!this.canBeAttribute(statement, hashSet)) continue;
                this.done(statement);
                this.wPropAttr(statement.getPredicate(), statement.getObject());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean wObj(Resource resource, boolean bl) throws RDFException {
        boolean bl2;
        block7: {
            boolean bl3;
            block6: {
                boolean bl4;
                block5: {
                    try {
                        this.doing.add(resource);
                        Statement statement = this.getType(resource);
                        if (statement != null) {
                            Resource resource2 = statement.getResource();
                            if (!bl && this.pleasingTypeSet.contains(resource2) && !this.isGenuineAnon(resource)) {
                                boolean bl5 = this.wTypedNodeNoProperties(resource);
                                Object var8_8 = null;
                                this.doing.remove(resource);
                                return bl5;
                            }
                            if (resource2.equals(RDF.Alt) || resource2.equals(RDF.Bag) || resource2.equals(RDF.Seq)) {
                                bl4 = this.wContainer(resource) || this.wDescription(resource);
                                break block5;
                            }
                            bl3 = this.wTypedNode(resource) || this.wDescription(resource);
                            break block6;
                        }
                        bl2 = this.wDescription(resource);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        this.doing.remove(resource);
                        throw throwable;
                    }
                }
                Object var8_9 = null;
                this.doing.remove(resource);
                return bl4;
            }
            Object var8_10 = null;
            this.doing.remove(resource);
            return bl3;
        }
        Object var8_11 = null;
        this.doing.remove(resource);
        return bl2;
    }

    private boolean wDescription(Resource resource) throws RDFException {
        return this.wTypedNodeOrDescription(rdfns, "Description", resource);
    }

    private boolean wTypedNode(Resource resource) throws RDFException {
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        String string = this.getNameSpace(resource2);
        String string2 = this.getLocalName(resource2);
        return this.wTypedNodeOrDescription(string, string2, resource);
    }

    private boolean wTypedNodeOrDescription(String string, String string2, Resource resource) throws RDFException {
        return this.wTypedNodeOrDescriptionCompact(string, string2, resource) || this.wTypedNodeOrDescriptionLong(string, string2, resource);
    }

    private boolean wTypedNodeOrDescriptionCompact(String string, String string2, Resource resource) throws RDFException {
        if (!this.allPropsAreAttr(resource)) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(string, string2);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource);
        this.wBagIdAttrOpt(resource);
        this.wPropAttrAll(resource);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeNoProperties(Resource resource) throws RDFException {
        if (this.isGenuineAnon(resource)) {
            return false;
        }
        Statement statement = this.getType(resource);
        if (statement == null) {
            return false;
        }
        Resource resource2 = statement.getResource();
        this.done(statement);
        this.tab();
        this.print("<");
        this.wQname(resource2);
        this.indentPlus();
        if (this.hasProperties(resource)) {
            this.wAboutAttr(resource);
        } else {
            this.wIdAboutAttrOpt(resource);
        }
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeOrDescriptionLong(String string, String string2, Resource resource) throws RDFException {
        this.tab();
        this.print("<");
        this.wQname(string, string2);
        this.indentPlus();
        this.wIdAboutAttrOpt(resource);
        this.wBagIdAttrOpt(resource);
        this.wPropAttrSome(resource);
        this.print(">");
        this.wPropertyEltStar(resource);
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wQname(string, string2);
        this.print(">");
        return true;
    }

    private void wPropertyEltStar(Resource resource) throws RDFException {
        StmtIterator stmtIterator = this.listProperties(resource);
        try {
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                this.wPropertyElt(statement, statement.getObject());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
    }

    private boolean wIdAboutAttrOpt(Resource resource) throws RDFException {
        return this.wIdAttrOpt(resource) || this.wAboutAttr(resource);
    }

    private boolean wIdAttrOpt(Resource resource) throws RDFException {
        if (this.isGenuineAnon(resource)) {
            return true;
        }
        if (this.isLocalReference(resource)) {
            if (this.wantReification(resource)) {
                return false;
            }
            if (this.idDone.contains(resource)) {
                return false;
            }
            this.idDone.add(resource);
            this.print(" ");
            this.wQname(rdfns, "ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            return true;
        }
        return false;
    }

    private boolean wAboutAttr(Resource resource) throws RDFException {
        this.print(" ");
        this.wQname(rdfns, "about");
        this.print("=");
        this.wURIreference(resource);
        return true;
    }

    private void wURIreference(Resource resource) throws RDFException {
        if (this.isLocalReference(resource)) {
            this.print(this.quote("#" + this.getLocalName(resource)));
        } else if (resource.getURI().equals(this.localName)) {
            this.print("''");
        } else {
            this.print(this.quote(resource.getURI()));
        }
    }

    private void wIdRefAttrOpt(Statement statement, Resource resource) throws RDFException {
        if (this.wantReification(statement)) {
            if (!this.isGenuineAnon(resource)) {
                this.error("Bad use of wIdRefAttrOpt rule - want both ID and resource");
            }
            this.wIdAttrReified(statement);
        } else if (!this.isGenuineAnon(resource)) {
            this.wResourceAttr(resource);
        }
    }

    private void wIdAttrReified(Statement statement) throws RDFException {
        if (this.wantReification(statement)) {
            Statement[] statementArray = this.reification(statement);
            Resource resource = (Resource)this.statement2res.get(statement);
            this.idDone.add(resource);
            int n = 0;
            while (n < statementArray.length) {
                this.done(statementArray[n]);
                ++n;
            }
            this.print(" ");
            this.wQname(rdfns, "ID");
            this.print("=");
            this.print(this.quote(this.getLocalName(resource)));
            this.haveReified.add(resource);
        }
    }

    private void wResourceAttr(Resource resource) throws RDFException {
        this.print(" ");
        this.wQname(rdfns, "resource");
        this.print("=");
        this.wURIreference(resource);
    }

    private void wBagIdAttrOpt(Resource resource) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean wContainer(Resource resource) throws RDFException {
        int n;
        Object object;
        BigInteger bigInteger;
        StmtIterator stmtIterator;
        Resource resource2;
        Statement statement;
        block19: {
            boolean bl;
            block21: {
                boolean bl2;
                statement = this.getType(resource);
                if (statement == null) {
                    return false;
                }
                resource2 = statement.getResource();
                if (!(resource2.equals(RDF.Alt) || resource2.equals(RDF.Bag) || resource2.equals(RDF.Seq))) {
                    return false;
                }
                if (!this.isLocalIDorAnon(resource)) {
                    return false;
                }
                stmtIterator = this.listProperties(resource);
                bigInteger = BigInteger.ZERO;
                try {
                    while (true) {
                        if (!stmtIterator.hasNext()) {
                            break block19;
                        }
                        object = stmtIterator.next();
                        n = object.getPredicate().getOrdinal();
                        if (n == 0) {
                            if (object.equals(statement)) continue;
                            this.codeCoverage[0] = this.codeCoverage[0] + 1;
                            bl2 = false;
                            Object var10_12 = null;
                            break;
                        }
                        if (bigInteger.testBit(n - 1)) {
                            this.codeCoverage[1] = this.codeCoverage[1] + 1;
                            bl = false;
                            break block21;
                        }
                        bigInteger = bigInteger.setBit(n - 1);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    stmtIterator.close();
                    throw throwable;
                }
                stmtIterator.close();
                return bl2;
            }
            Object var10_13 = null;
            stmtIterator.close();
            return bl;
        }
        Statement statement2 = null;
        stmtIterator.close();
        object = bigInteger.add(BigInteger.ONE);
        if (((BigInteger)object).bitCount() != 1) {
            this.codeCoverage[2] = this.codeCoverage[2] + 1;
            return false;
        }
        n = ((BigInteger)object).getLowestSetBit();
        this.done(statement);
        stmtIterator = this.listProperties(resource);
        try {
            while (true) {
                if (!stmtIterator.hasNext()) {
                    Object var12_19 = null;
                    break;
                }
                Statement statement3 = stmtIterator.next();
                int n2 = statement3.getPredicate().getOrdinal();
                if (n2 == 0) continue;
                this.done(statement3);
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        this.tab();
        this.print("<");
        this.wTypeName(resource2);
        if (!this.wIdAttrOpt(resource)) {
            this.error("Bad Container ID problem.");
        }
        if (n == 0) {
            this.codeCoverage[3] = this.codeCoverage[3] + 1;
            this.tab();
            this.print("/>");
            return true;
        }
        this.print(">");
        this.indentPlus();
        int n3 = 1;
        while (true) {
            if (n3 > n) {
                this.indentMinus();
                this.tab();
                this.print("</");
                this.wTypeName(resource2);
                this.print(">");
                return true;
            }
            Property property = RDF.li(n3);
            statement2 = resource.getProperty(property);
            if (!this.wMember(statement2)) {
                this.error("Member problem.");
            }
            ++n3;
        }
    }

    private void wTypeName(Resource resource) throws RDFException {
        this.wQname(resource);
    }

    private void wQname(Resource resource) throws RDFException {
        this.wQname(this.getNameSpace(resource), this.getLocalName(resource));
    }

    private void wQname(String string, String string2) {
        this.print(this.nameSpaceAbbreviation(string) + ":" + string2);
    }

    private void wPropName(Statement statement) throws RDFException {
        this.wQname(statement.getPredicate());
    }

    private void wPropName(Property property) throws RDFException {
        this.wQname(property);
    }

    private void wPropAttr(Property property, RDFNode rDFNode) throws RDFException {
        this.tab();
        if (property.equals(RDF.type)) {
            this.wTypeAttr((Resource)rDFNode);
        } else {
            this.wPropAttrString(property, (Literal)rDFNode);
        }
    }

    private void wTypeAttr(Resource resource) {
        this.print(" ");
        this.wQname(rdfns, "type");
        this.print("=");
        this.print(this.quote(resource.getURI()));
    }

    private void wPropAttrString(Property property, Literal literal) throws RDFException {
        this.print(" ");
        this.wPropName(property);
        this.print("=" + this.quote(literal.getString()));
    }

    private boolean wMember(Statement statement) throws RDFException {
        return this.wInlineItem(statement) || this.wReferencedItem(statement);
    }

    private boolean wInlineItem(Statement statement) throws RDFException {
        return this.wInlineItemLiteral(statement) || this.wInlineItemValueString(statement) || this.wInlineItemResource(statement) || this.wInlineItemValueObj(statement);
    }

    private boolean wInlineItemLiteral(Statement statement) {
        if (!(statement.getObject() instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)statement.getObject();
        if (!literal.getWellFormed()) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(rdfns, "li");
        this.print(">");
        this.print(literal.toString());
        this.print("</");
        this.wQname(rdfns, "li");
        this.print(">");
        return true;
    }

    private boolean wInlineItemValueString(Statement statement) throws RDFException {
        if (!(statement.getObject() instanceof Literal)) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(rdfns, "li");
        this.print(">");
        this.wValueString((Literal)statement.getObject());
        this.print("</");
        this.wQname(rdfns, "li");
        this.print(">");
        return true;
    }

    private boolean wInlineItemResource(Statement statement) throws RDFException {
        if (!(statement.getObject() instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)statement.getObject();
        if (!this.isGenuineAnon(resource)) {
            return false;
        }
        if (this.getType(resource) != null) {
            return false;
        }
        if (!this.hasProperties(resource)) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(rdfns, "li");
        this.wParseResource();
        this.print(">");
        this.indentPlus();
        this.wPropertyEltStar((Resource)statement.getObject());
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wQname(rdfns, "li");
        this.print(">");
        return true;
    }

    private boolean wInlineItemValueObj(Statement statement) throws RDFException {
        if (!(statement.getObject() instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)statement.getObject();
        if (!this.hasProperties(resource)) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(rdfns, "li");
        this.print(">");
        this.indentPlus();
        this.wObj((Resource)statement.getObject(), false);
        this.indentMinus();
        this.tab();
        this.print("</");
        this.wQname(rdfns, "li");
        this.print(">");
        return true;
    }

    private boolean wReferencedItem(Statement statement) throws RDFException {
        if (!(statement.getObject() instanceof Resource)) {
            return false;
        }
        this.tab();
        this.print("<");
        this.wQname(rdfns, "li");
        this.wResourceAttr(statement.getResource());
        this.print("/>");
        return true;
    }

    private void wParseDamlCollection() {
        this.print(" ");
        this.wQname(rdfns, "parseType");
        this.print("='daml:collection'");
    }

    private void wParseLiteral() {
        this.print(" ");
        this.wQname(rdfns, "parseType");
        this.print("='Literal'");
    }

    private void wParseResource() {
        this.print(" ");
        this.wQname(rdfns, "parseType");
        this.print("='Resource'");
    }

    private void printNameSpaceDefn() {
        Iterator iterator = this.nameSpaces.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.tab();
            this.print("xmlns:" + entry.getValue() + "=" + this.quote((String)entry.getKey()));
        }
    }

    private static String filler(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private void tab() {
        int n = 4 * this.indentLevel;
        if (n == 0 && this.currentColumn == 0 || n > this.currentColumn) {
            String string = Unparser.filler(n - this.currentColumn);
            this.out.print(string);
        } else {
            this.out.println();
            this.out.print(Unparser.filler(n));
        }
        this.currentColumn = n;
    }

    private String quote(String string) {
        return "'" + Util.substituteStandardEntities(string) + "'";
    }

    private void print(String string) {
        this.out.print(string);
        int n = string.lastIndexOf(10);
        this.currentColumn = n == -1 ? (this.currentColumn += string.length()) : string.length() - n - 1;
    }

    private void indentPlus() {
        ++this.indentLevel;
    }

    private void indentMinus() {
        --this.indentLevel;
    }

    private void error(String string) {
        RuntimeException runtimeException = new RuntimeException("Internal error in Unparser: " + string);
        this.prettyWriter.fatalError(runtimeException);
        throw runtimeException;
    }

    private static String specialPrefix(String string) {
        String string2 = (String)specialPrefixes.get(string);
        if (string2 == null && string.startsWith("http://www.daml.org/") && string.endsWith("daml+oil#")) {
            return "daml";
        }
        return string2;
    }

    private void addNameSpace(String string, Relation relation) {
        String string2 = Unparser.specialPrefix(string);
        if (relation.backward(string2) != null) {
            string2 = null;
        }
        if (string2 == null) {
            if (relation.forward(string) != null) {
                return;
            }
            string2 = "RDFNsId" + this.genSym++;
        }
        relation.set(string, string2);
    }

    private Relation listNameSpaces() throws RDFException {
        String string;
        Object object;
        Relation relation = new Relation();
        this.genSym = 1;
        NsIterator nsIterator = this.model.listNameSpaces();
        try {
            while (nsIterator.hasNext()) {
                object = nsIterator.next();
                this.addNameSpace((String)object, relation);
            }
            string = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            nsIterator.close();
            throw throwable;
        }
        nsIterator.close();
        object = this.model.listObjectsOfProperty(RDF.type);
        try {
            while (object.hasNext()) {
                int n;
                RDFNode rDFNode = object.next();
                if (!(rDFNode instanceof Resource) || ((Resource)rDFNode).isAnon() || (n = (string = ((Resource)rDFNode).getURI()).lastIndexOf(35)) == -1) continue;
                this.addNameSpace(string.substring(0, n + 1), relation);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            object.close();
            throw throwable;
        }
        object.close();
        if (relation.backward("rdf") == null) {
            relation.set(rdfns, "rdf");
        }
        return relation;
    }

    private String nameSpaceAbbreviation(String string) {
        Set set = this.nameSpaces.forward(string);
        if (set == null || set.isEmpty()) {
            this.error("Name space cock-up: " + string);
        }
        return (String)set.iterator().next();
    }

    private String getNameSpace(Resource resource) {
        if (resource.isAnon()) {
            return this.localName + "#";
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(0, n);
    }

    private boolean isGenuineAnon(Resource resource) {
        if (!resource.isAnon()) {
            return false;
        }
        Integer n = (Integer)this.objectTable.get(resource);
        return n == null || n <= 1 && !this.haveReified.contains(resource);
    }

    private boolean isLocalReference(Resource resource) {
        return resource.isAnon() || this.getNameSpace(resource).equals(this.localName + "#");
    }

    private boolean isLocalIDorAnon(Resource resource) {
        return this.isGenuineAnon(resource) || this.isLocalReference(resource) && !this.idDone.contains(resource);
    }

    private static String getSuffix(int n) {
        if (n == 0) {
            return "";
        }
        int n2 = --n / 26;
        return Unparser.getSuffix(n2) + new Character((char)(97 + n % 26));
    }

    private String getLocalName(Resource resource) throws RDFException {
        if (resource.isAnon()) {
            String string = (String)this.localNameMap.get(resource);
            if (string == null) {
                Resource resource2;
                boolean bl = false;
                do {
                    string = "RDFAnon" + this.localId++;
                    resource2 = this.model.createResource(this.localName + "#" + string);
                    StmtIterator stmtIterator = resource2.listProperties();
                    bl = stmtIterator.hasNext();
                    stmtIterator.close();
                } while (bl || this.objectTable.get(resource2) != null);
                this.localNameMap.put(resource, string);
            }
            return string;
        }
        String string = resource.getURI();
        int n = Util.splitNamespace(string);
        return string.substring(n);
    }

    private void increaseObjectCount(Resource resource) {
        Integer n = (Integer)this.objectTable.get(resource);
        n = n == null ? one : new Integer(n + 1);
        this.objectTable.put(resource, n);
    }

    private boolean wantReification(Statement statement) throws RDFException {
        return this.wantReification(statement, (Resource)this.statement2res.get(statement));
    }

    private boolean wantReification(Resource resource) throws RDFException {
        return this.wantReification((Statement)this.res2statement.get(resource), resource);
    }

    private boolean wantReification(Statement statement, Resource resource) throws RDFException {
        if (statement == null || resource == null) {
            return false;
        }
        if (!this.isLocalReference(resource) || !this.isLocalReference(statement)) {
            return false;
        }
        Statement[] statementArray = this.reification(statement);
        int n = 0;
        while (n < statementArray.length) {
            if (this.doneSet.contains(statementArray[n]) || !this.model.contains(statementArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Statement[] reification(Statement statement) throws RDFException {
        Model model = statement.getModel();
        Resource resource = (Resource)this.statement2res.get(statement);
        return new Statement[]{model.createStatement(resource, RDF.type, RDF.Statement), model.createStatement(resource, RDF.subject, statement.getSubject()), model.createStatement(resource, RDF.predicate, statement.getPredicate()), model.createStatement(resource, RDF.object, statement.getObject())};
    }

    private boolean hasProperties(Resource resource) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator = this.listProperties(resource);
        if (this.avoidExplicitReification && !resource.isAnon() && this.isLocalReference(resource) && this.res2statement.containsKey(resource)) {
            stmtIterator = new FilterStmtIterator(new Filter(){

                public boolean accept(Object object) {
                    Statement statement = (Statement)object;
                    Property property = statement.getPredicate();
                    String string = property.getLocalName();
                    return !property.getNameSpace().equals(rdfns) || (!RDF.type.equals(property) || !statement.getObject().equals(RDF.Statement)) && !RDF.object.equals(property) && !RDF.predicate.equals(property) && !RDF.subject.equals(property);
                }
            }, stmtIterator);
        }
        try {
            bl = stmtIterator.hasNext();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return bl;
    }

    private StmtIterator listProperties(Resource resource) throws RDFException {
        return new FilterStmtIterator(new Filter(){

            public boolean accept(Object object) {
                return !Unparser.this.doneSet.contains(object);
            }
        }, resource.listProperties());
    }

    private boolean canBeAttribute(Statement statement, Set set) throws RDFException {
        String string;
        Literal literal;
        Property property = statement.getPredicate();
        if (set.contains(property)) {
            return false;
        }
        set.add(property);
        if (property.equals(RDF.type)) {
            RDFNode rDFNode = statement.getObject();
            return rDFNode instanceof Resource && !((Resource)rDFNode).isAnon();
        }
        if (statement.getObject() instanceof Literal && (literal = statement.getLiteral()).getLanguage().equals("") && (string = literal.getString()).length() < 40) {
            char[] cArray = string.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] <= ' ') {
                    return false;
                }
                ++n;
            }
            return !this.wantReification(statement);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean allPropsAreAttr(Resource resource) throws RDFException {
        StmtIterator stmtIterator;
        block3: {
            boolean bl;
            stmtIterator = this.listProperties(resource);
            HashSet hashSet = new HashSet();
            try {
                Statement statement;
                do {
                    if (stmtIterator.hasNext()) continue;
                    break block3;
                } while (this.canBeAttribute(statement = stmtIterator.next(), hashSet));
                bl = false;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                stmtIterator.close();
                throw throwable;
            }
            stmtIterator.close();
            return bl;
        }
        Object var7_7 = null;
        stmtIterator.close();
        return true;
    }

    private void done(Statement statement) {
        this.doneSet.add(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Statement[][] getDamlList(RDFNode rDFNode) throws RDFException {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        RDFNode rDFNode2 = rDFNode;
        block2: while (true) {
            Object var15_13;
            StmtIterator stmtIterator;
            block21: {
                Statement[][] statementArray;
                block26: {
                    Statement[][] statementArray2;
                    block25: {
                        Statement[][] statementArray3;
                        block24: {
                            Statement[][] statementArray4;
                            block23: {
                                Statement[][] statementArray5;
                                if (rDFNode2.equals(DAML.nil)) {
                                    if (vector.size() != 0) break;
                                    return null;
                                }
                                objectArray = new Statement[3];
                                if (rDFNode2 instanceof Literal) {
                                    return null;
                                }
                                Resource resource = (Resource)rDFNode2;
                                if (!this.isGenuineAnon(resource)) {
                                    return null;
                                }
                                if (hashSet.contains(rDFNode2)) {
                                    return null;
                                }
                                hashSet.add(rDFNode2);
                                stmtIterator = resource.listProperties();
                                try {
                                    while (true) {
                                        int n;
                                        if (!stmtIterator.hasNext()) {
                                            break block21;
                                        }
                                        Statement statement = stmtIterator.next();
                                        Property property = statement.getPredicate();
                                        RDFNode rDFNode3 = statement.getObject();
                                        if (this.doneSet.contains(statement)) {
                                            statementArray5 = null;
                                            var15_13 = null;
                                            break;
                                        }
                                        if (!(rDFNode3 instanceof Resource)) {
                                            statementArray4 = null;
                                            break block23;
                                        }
                                        if (property.equals(RDF.type)) {
                                            n = 2;
                                            if (!rDFNode3.equals(DAML.List)) {
                                                statementArray3 = null;
                                                break block24;
                                            }
                                        } else if (property.equals(DAML.first)) {
                                            n = 0;
                                        } else {
                                            if (!property.equals(DAML.rest)) {
                                                statementArray2 = null;
                                                break block25;
                                            }
                                            n = 1;
                                            rDFNode2 = rDFNode3;
                                        }
                                        if (objectArray[n] != null) {
                                            statementArray = null;
                                            break block26;
                                        }
                                        objectArray[n] = statement;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var15_13 = null;
                                    stmtIterator.close();
                                    throw throwable;
                                }
                                stmtIterator.close();
                                return statementArray5;
                            }
                            var15_13 = null;
                            stmtIterator.close();
                            return statementArray4;
                        }
                        var15_13 = null;
                        stmtIterator.close();
                        return statementArray3;
                    }
                    var15_13 = null;
                    stmtIterator.close();
                    return statementArray2;
                }
                var15_13 = null;
                stmtIterator.close();
                return statementArray;
            }
            var15_13 = null;
            stmtIterator.close();
            int n = 0;
            while (true) {
                if (n >= 3) {
                    vector.add(objectArray);
                    continue block2;
                }
                if (objectArray[n] == null) {
                    return null;
                }
                ++n;
            }
            break;
        }
        objectArray = new Statement[vector.size()][];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Statement getType(Resource resource) throws RDFException {
        Statement statement;
        try {
            if (resource instanceof Statement) {
                statement = ((Statement)resource).getStatementProperty(RDF.type);
                if (statement == null || !statement.getObject().equals(RDF.Statement)) {
                    this.error("Statement type problem");
                }
            } else {
                statement = resource.getProperty(RDF.type);
            }
        }
        catch (RDFException rDFException) {
            if (rDFException.getErrorCode() == 6) {
                if (resource instanceof Statement) {
                    this.error("Statement type problem");
                }
                statement = null;
            }
            throw rDFException;
        }
        if (statement == null) {
            return null;
        }
        RDFNode rDFNode = statement.getObject();
        if (!(rDFNode instanceof Resource)) {
            return null;
        }
        if (((Resource)rDFNode).isAnon()) {
            return null;
        }
        String string = ((Resource)rDFNode).getURI();
        int n = string.lastIndexOf(35);
        if (n == -1) {
            return null;
        }
        int n2 = Util.splitNamespace(string);
        if (n2 != n + 1) {
            return null;
        }
        return statement;
    }

    private void findInfiniteCycles() throws RDFException {
        StmtIterator stmtIterator = this.model.listStatements();
        Relation relation = new Relation();
        try {
            while (stmtIterator.hasNext()) {
                RDFNode rDFNode;
                Statement statement = stmtIterator.next();
                if (this.doneSet.contains(statement) || !((rDFNode = statement.getObject()) instanceof Resource)) continue;
                relation.set(statement.getSubject(), rDFNode);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        relation.transitiveClosure();
        this.infinite = relation.getDiagonal();
    }

    private Iterator allInfiniteLeft() {
        return new LateBindingIterator(){

            public Iterator create() {
                return Unparser.this.infinite.iterator();
            }
        };
    }

    private Iterator pleasingTypeIterator() throws RDFException {
        if (this.pleasingTypes == null) {
            return new NullIterator();
        }
        HashMap<Resource, Set> hashMap = new HashMap<Resource, Set>();
        Set[] setArray = new Set[this.pleasingTypes.length];
        int n = 0;
        while (n < this.pleasingTypes.length) {
            setArray[n] = new HashSet();
            hashMap.put(this.pleasingTypes[n], setArray[n]);
            ++n;
        }
        ResIterator resIterator = this.model.listSubjects();
        try {
            while (resIterator.hasNext()) {
                Set set;
                Resource resource = resIterator.next();
                Statement statement = this.getType(resource);
                if (statement == null || (set = (Set)hashMap.get(statement.getObject())) == null) continue;
                set.add(resource);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            resIterator.close();
            throw throwable;
        }
        resIterator.close();
        return new IteratorIterator(new Map1Iterator(new Map1(){

            public Object map1(Object object) {
                return ((Set)object).iterator();
            }
        }, new ArrayIterator(setArray)));
    }

    private Iterator listSubjects() throws RDFException {
        ArrayIterator arrayIterator = new ArrayIterator(new Resource[]{this.model.createResource(this.localName)});
        Iterator iterator = this.pleasingTypeIterator();
        NullIterator nullIterator = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.pleasingTypeSet = new HashSet();
                return false;
            }
        };
        FilterIterator filterIterator = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                return !Unparser.this.objectTable.containsKey(object);
            }
        }, this.modelListSubjects());
        NullIterator nullIterator2 = new NullIterator(){

            public boolean hasNext() {
                try {
                    Unparser.this.findInfiniteCycles();
                }
                catch (RDFException rDFException) {
                    throw new RuntimeRDFException(rDFException);
                }
                return false;
            }
        };
        FilterIterator filterIterator2 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Resource resource = (Resource)object;
                Unparser.this.codeCoverage[4] = Unparser.this.codeCoverage[4] + 1;
                if (resource.isAnon()) {
                    return false;
                }
                Integer n = (Integer)Unparser.this.objectTable.get(resource);
                return n != null && n > 1;
            }
        }, this.allInfiniteLeft());
        FilterIterator filterIterator3 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[5] = Unparser.this.codeCoverage[5] + 1;
                Resource resource = (Resource)object;
                return !Unparser.this.isGenuineAnon(resource);
            }
        }, this.allInfiniteLeft());
        Iterator iterator2 = this.allInfiniteLeft();
        NullIterator nullIterator3 = new NullIterator(){

            public boolean hasNext() {
                Unparser.this.avoidExplicitReification = false;
                return false;
            }
        };
        FilterIterator filterIterator4 = new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Unparser.this.codeCoverage[6] = Unparser.this.codeCoverage[6] + 1;
                return object instanceof Statement;
            }
        }, this.allInfiniteLeft());
        Iterator iterator3 = this.modelListSubjects();
        Iterator[] iteratorArray = new Iterator[]{arrayIterator, iterator, nullIterator, filterIterator, nullIterator2, filterIterator2, filterIterator3, iterator2, nullIterator3, filterIterator4, new NullIterator(){

            public boolean hasNext() {
                if (Unparser.this.modelListSubjects().hasNext()) {
                    Unparser.this.codeCoverage[7] = Unparser.this.codeCoverage[7] + 1;
                }
                return false;
            }
        }, iterator3};
        IteratorIterator iteratorIterator = new IteratorIterator(new ArrayIterator(iteratorArray));
        return new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                try {
                    return Unparser.this.hasProperties((Resource)object);
                }
                catch (RDFException rDFException) {
                    throw new RuntimeRDFException(rDFException);
                }
            }
        }, iteratorIterator);
    }

    private synchronized void close(ResIterator resIterator) throws RDFException {
        resIterator.close();
        this.openResIterators.remove(resIterator);
    }

    private synchronized void closeAllResIterators() throws RDFException {
        Iterator iterator = this.openResIterators.iterator();
        while (iterator.hasNext()) {
            ((ResIterator)iterator.next()).close();
        }
        this.openResIterators = new HashSet();
    }

    private Iterator modelListSubjects() {
        try {
            ResIterator resIterator = this.model.listSubjects();
            this.openResIterators.add(resIterator);
            return new SubjectIterator(resIterator);
        }
        catch (RDFException rDFException) {
            throw new RuntimeRDFException(rDFException);
        }
    }

    static {
        specialPrefixes.put(RDF.getURI(), "rdf");
        specialPrefixes.put(RDFS.getURI(), "rdfs");
        specialPrefixes.put(RSS.getURI(), "rss");
    }

    private class SubjectIterator
    implements Iterator {
        private ResIterator resIt;
        private boolean dead = false;

        SubjectIterator(ResIterator resIterator) {
            this.resIt = resIterator;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.dead) {
                throw new NoSuchElementException();
            }
            try {
                return this.resIt.next();
            }
            catch (RDFException rDFException) {
                throw new RuntimeRDFException(rDFException);
            }
        }

        public boolean hasNext() {
            if (this.dead) {
                return false;
            }
            try {
                boolean bl = this.resIt.hasNext();
                if (!bl) {
                    this.dead = true;
                    Unparser.this.close(this.resIt);
                }
                return bl;
            }
            catch (RDFException rDFException) {
                throw new RuntimeRDFException(rDFException);
            }
        }
    }
}

