/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.httpclient.Authenticator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIUtil;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public abstract class HttpMethodBase
implements HttpMethod {
    private String path = null;
    private boolean followRedirects = false;
    private String queryString = null;
    private HashMap requestHeaders = new HashMap();
    private HashMap responseHeaders = new HashMap();
    private int statusCode = -1;
    private String statusText = null;
    private boolean used = false;
    private boolean http11 = true;
    private boolean bodySent = false;
    private byte[] responseBody = null;
    private int maxRetries = 3;
    private boolean strictMode = true;
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpMethod");
    private static final Log wireLog = LogSource.getInstance("httpclient.wire");
    protected static final Header USER_AGENT = new Header("User-Agent", "Jakarta HTTP Client/2.0.0a1");

    public HttpMethodBase() {
    }

    public HttpMethodBase(String path) {
        this.setPath(path);
    }

    public abstract String getName();

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        Header header = new Header(headerName, headerValue);
        this.requestHeaders.put(headerName.toLowerCase(), header);
    }

    public void setRequestHeader(Header header) {
        this.requestHeaders.put(header.getName().toLowerCase(), header);
    }

    public void addRequestHeader(String headerName, String headerValue) {
        Header header = (Header)this.requestHeaders.get(headerName.toLowerCase());
        if (null == header) {
            header = new Header(headerName, headerValue);
        } else {
            header.setValue((null == header.getValue() ? "" : header.getValue()) + ", " + (null == headerValue ? "" : headerValue));
        }
        this.requestHeaders.put(headerName.toLowerCase(), header);
    }

    public void addRequestHeader(Header header) {
        Header orig = (Header)this.requestHeaders.get(header.getName().toLowerCase());
        if (null == orig) {
            orig = header;
        } else {
            orig.setValue((null == orig.getValue() ? "" : orig.getValue()) + ", " + (null == header.getValue() ? "" : header.getValue()));
        }
        this.requestHeaders.put(orig.getName().toLowerCase(), orig);
    }

    public Header getRequestHeader(String headerName) {
        return (Header)this.requestHeaders.get(headerName.toLowerCase());
    }

    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName.toLowerCase());
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryString(NameValuePair[] params) {
        StringBuffer buf = new StringBuffer();
        boolean needAmp = false;
        int i = 0;
        while (i < params.length) {
            if (needAmp) {
                buf.append("&");
            } else {
                needAmp = true;
            }
            if (null != params[i].getName()) {
                buf.append(URIUtil.encode(params[i].getName()));
            }
            if (null != params[i].getValue()) {
                buf.append("=");
                buf.append(URIUtil.encode(params[i].getValue()));
            }
            ++i;
        }
        this.queryString = buf.toString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Header[] getRequestHeaders() {
        return this.requestHeaders.values().toArray(new Header[this.requestHeaders.size()]);
    }

    public boolean validate() {
        return true;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders.values().toArray(new Header[this.responseHeaders.size()]);
    }

    public Header getResponseHeader(String headerName) {
        return (Header)this.responseHeaders.get(headerName.toLowerCase());
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return null == this.responseBody ? null : new String(this.responseBody);
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return null == this.responseBody ? null : new ByteArrayInputStream(this.responseBody);
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public int execute(HttpState state, HttpConnection connection) throws HttpException, IOException {
        block48: {
            block49: {
                if (log.isDebugEnabled()) {
                    log.debug("HttpMethodBase.execute(HttpState,HttpConnection)");
                }
                if (null == state) {
                    throw new NullPointerException("HttpState parameter");
                }
                if (null == connection) {
                    throw new NullPointerException("HttpConnection parameter");
                }
                if (this.hasBeenUsed()) {
                    throw new HttpException("Already used, but not recycled.");
                }
                if (!this.validate()) {
                    throw new HttpException("Not valid");
                }
                HashSet<String> visited = new HashSet<String>();
                HashSet<String> realms = new HashSet<String>();
                int retryCount = 0;
                while (true) {
                    visited.add(connection.getHost() + ":" + connection.getPort() + "|" + HttpMethodBase.generateRequestLine(connection, this.getName(), this.getPath(), this.getQueryString(), this.http11 ? "HTTP/1.1" : "HTTP/1.0"));
                    if (log.isDebugEnabled()) {
                        log.debug("HttpMethodBase.execute(): looping.");
                    }
                    try {
                        if (!connection.isOpen()) {
                            if (log.isDebugEnabled()) {
                                log.debug("HttpMethodBase.execute(): opening connection.");
                            }
                            connection.open();
                        }
                        this.writeRequest(state, connection);
                        this.used = true;
                        this.readResponse(state, connection);
                    }
                    catch (HttpRecoverableException e) {
                        if (retryCount >= this.maxRetries) {
                            throw new HttpException(e.toString());
                        }
                        ++retryCount;
                        connection.close();
                        log.debug("HttpMethodBase.execute():  Caught recoverable exception, retrying...");
                        continue;
                    }
                    if (100 == this.statusCode) {
                        if (!this.bodySent) {
                            this.bodySent = this.writeRequestBody(state, connection);
                        } else {
                            log.warn("HttpMethodBase.execute(): received 100 response, but I've already sent the response.");
                        }
                        this.readResponse(state, connection);
                    }
                    if (!this.http11) {
                        if (log.isDebugEnabled()) {
                            log.debug("HttpMethodBase.execute(): closing connection since we're using HTTP/1.0");
                        }
                        connection.close();
                    } else {
                        Header connectionHeader = this.getResponseHeader("connection");
                        if (null != connectionHeader && "close".equalsIgnoreCase(connectionHeader.getValue())) {
                            if (log.isDebugEnabled()) {
                                log.debug("HttpMethodBase.execute(): closing connection since \"Connection: close\" header found.");
                            }
                            connection.close();
                        }
                    }
                    if (401 == this.statusCode) {
                        Header wwwauth = this.getResponseHeader("WWW-Authenticate");
                        if (null == wwwauth) continue;
                        String pathAndCreds = this.getPath() + ":" + wwwauth.getValue();
                        if (realms.contains(pathAndCreds)) {
                            if (!log.isInfoEnabled()) break block48;
                            log.info("Already tried to authenticate to \"" + wwwauth.getValue() + "\" but still receiving " + 401 + ".");
                            break block48;
                        }
                        realms.add(pathAndCreds);
                        boolean authenticated = false;
                        try {
                            authenticated = Authenticator.authenticate(this, state);
                        }
                        catch (HttpException e) {
                            // empty catch block
                        }
                        if (!authenticated) {
                            if (!log.isDebugEnabled()) break block48;
                            log.debug("HttpMethodBase.execute(): Server demands authentication credentials, but none are available, so aborting.");
                            break block48;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("HttpMethodBase.execute(): Server demanded authentication credentials, will try again.");
                        continue;
                    }
                    if (302 != this.statusCode && 301 != this.statusCode && 307 != this.statusCode) break block48;
                    if (!this.getFollowRedirects()) break block49;
                    Header location = this.getResponseHeader("location");
                    if (location == null) break;
                    URL url = null;
                    try {
                        if (location.getValue().startsWith("/")) {
                            if (log.isDebugEnabled()) {
                                log.debug("Following relative Location header \"" + location + "\".");
                            }
                            String protocol = connection.isSecure() ? "https" : "http";
                            int port = connection.getPort();
                            if (-1 == port) {
                                port = connection.isSecure() ? 443 : 80;
                            }
                            url = new URL(protocol, connection.getHost(), port, location.getValue());
                        } else if (!this.isStrictMode() && location.getValue().indexOf("://") < 0) {
                            String protocol = connection.isSecure() ? "https" : "http";
                            int port = connection.getPort();
                            if (-1 == port) {
                                port = connection.isSecure() ? 443 : 80;
                            }
                            URL currentUrl = new URL(protocol, connection.getHost(), port, this.getPath());
                            url = new URL(currentUrl, location.getValue());
                        } else {
                            url = new URL(location.getValue());
                        }
                    }
                    catch (MalformedURLException e) {
                        log.error("Exception while parsing location header \"" + location + "\"", e);
                        throw new HttpException(e.toString());
                    }
                    if ("http".equalsIgnoreCase(url.getProtocol())) {
                        if (connection.isSecure()) {
                            log.info("Server is attempting to redirect an HTTPS request to an HTTP one.");
                            throw new HttpException("Server is attempting to redirect an HTTPS request to an HTTP one.");
                        }
                    } else if ("https".equalsIgnoreCase(url.getProtocol()) && !connection.isSecure()) {
                        log.info("Server is attempting to convert an HTTP request to an HTTP one, which is currently not supported. Returning " + this.statusCode + ".");
                        break block48;
                    }
                    if (!connection.getHost().equalsIgnoreCase(url.getHost())) {
                        log.info("Server is attempting to redirect a different host, which is currently not supported. Returning " + this.statusCode + ".");
                        break block48;
                    }
                    if (url.getPort() == -1) {
                        if (connection.isSecure()) {
                            if (connection.getPort() != 443) {
                                log.info("Server is attempting to redirect a different port, which is currently not supported. Returning " + this.statusCode + ".");
                                break block48;
                            }
                        } else if (connection.getPort() != 80) {
                            log.info("Server is attempting to redirect a different port, which is currently not supported. Returning " + this.statusCode + ".");
                            break block48;
                        }
                    } else if (connection.getPort() != url.getPort()) {
                        log.info("Server is attempting to redirect a different port, which is currently not supported. Returning " + this.statusCode + ".");
                        break block48;
                    }
                    String absolutePath = URIUtil.getPath(url.toString());
                    String qs = URIUtil.getQueryString(url.toString());
                    if (visited.contains(connection.getHost() + ":" + connection.getPort() + "|" + HttpMethodBase.generateRequestLine(connection, this.getName(), absolutePath, qs, this.http11 ? "HTTP/1.1" : "HTTP/1.0"))) {
                        throw new HttpException("Redirect going into a loop, visited \"" + absolutePath + "\" already.");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Changing path from \"" + this.getPath() + "\" to \"" + absolutePath + "\" in response to " + this.statusCode + " response.");
                        log.debug("Changing query string from \"" + this.getQueryString() + "\" to \"" + qs + "\" in response to " + this.statusCode + " response.");
                    }
                    this.setPath(URIUtil.decode(absolutePath));
                    this.setQueryString(qs);
                }
                if (!log.isInfoEnabled()) break block48;
                log.info("HttpMethodBase.execute(): Received " + this.statusCode + " response, but no \"Location\" header. Returning " + this.statusCode + ".");
                break block48;
            }
            log.info("HttpMethodBase.execute(): Received " + this.statusCode + " response, but followRedirects is false. Returning " + this.statusCode + ".");
        }
        return this.statusCode;
    }

    protected void writeRequest(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.writeRequest(HttpState,HttpConnection)");
        }
        this.writeRequestLine(state, conn);
        this.writeRequestHeaders(state, conn);
        conn.writeLine();
        this.bodySent = this.writeRequestBody(state, conn);
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.writeRequestLine(HttpState,HttpConnection)");
        }
        String requestLine = HttpMethodBase.generateRequestLine(conn, this.getName(), this.getPath(), this.getQueryString(), this.http11 ? "HTTP/1.1" : "HTTP/1.0");
        conn.print(requestLine);
    }

    protected void writeRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        }
        this.addRequestHeaders(state, conn);
        Iterator it = this.requestHeaders.values().iterator();
        while (it.hasNext()) {
            conn.print(((Header)it.next()).toExternalForm());
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addCookieRequestHeader(state, conn);
        this.addAuthorizationRequestHeader(state, conn);
        this.addContentLengthRequestHeader(state, conn);
    }

    protected void addUserAgentRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (!this.requestHeaders.containsKey("user-agent")) {
            this.setRequestHeader(USER_AGENT);
        }
    }

    protected void addHostRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (!this.requestHeaders.containsKey("host")) {
            this.setRequestHeader("Host", conn.getHost());
        }
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        Header cookieHeader = Cookie.createCookieHeader(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), new Date(), state.getCookies());
        if (null != cookieHeader) {
            this.setRequestHeader(cookieHeader);
        }
    }

    protected void addAuthorizationRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        Header wwwAuthenticateHeader;
        if (!this.requestHeaders.containsKey("authorization") && null != (wwwAuthenticateHeader = (Header)this.responseHeaders.get("www-authenticate"))) {
            try {
                Authenticator.authenticate(this, state);
            }
            catch (HttpException e) {
                // empty catch block
            }
        }
    }

    protected void addContentLengthRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        int len = this.getRequestContentLength();
        if (!this.requestHeaders.containsKey("content-length")) {
            if (0 < len) {
                this.setRequestHeader("Content-Length", String.valueOf(len));
            } else if (this.http11 && len < 0) {
                this.setRequestHeader("Transfer-Encoding", "chunked");
            }
        }
    }

    protected int getRequestContentLength() {
        return 0;
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        return true;
    }

    protected void readResponse(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.readResponse(HttpState,HttpConnection)");
        }
        this.readStatusLine(state, conn);
        this.processStatusLine(state, conn);
        this.readResponseHeaders(state, conn);
        this.processResponseHeaders(state, conn);
        this.readResponseBody(state, conn);
        this.processResponseBody(state, conn);
    }

    protected void readStatusLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.readStatusLine(HttpState,HttpConnection)");
        }
        this.statusCode = -1;
        this.statusText = null;
        String statusLine = conn.readLine();
        while (statusLine != null && !statusLine.startsWith("HTTP/")) {
            statusLine = conn.readLine();
        }
        if (statusLine == null) {
            throw new HttpRecoverableException("Error in parsing the status line from the response: unable to find line starting with \"HTTP/\"");
        }
        if (!statusLine.startsWith("HTTP/1.1") && !statusLine.startsWith("HTTP/1.0")) {
            throw new HttpException("Unrecognized server protocol :" + statusLine);
        }
        this.http11 = statusLine.startsWith("HTTP/1.1");
        int at = statusLine.indexOf(" ");
        if (at < 0) {
            throw new HttpException("Unable to parse the status line: " + statusLine);
        }
        int to = statusLine.indexOf(" ", at + 1);
        if (to < 0) {
            to = statusLine.length();
        }
        try {
            this.statusCode = Integer.parseInt(statusLine.substring(at + 1, to));
        }
        catch (NumberFormatException e) {
            throw new HttpException("Unable to parse status code from status line: " + statusLine);
        }
        try {
            if (to < statusLine.length()) {
                this.statusText = statusLine.substring(to + 1);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HttpException("Status text not specified: " + statusLine);
        }
    }

    protected void processStatusLine(HttpState state, HttpConnection conn) {
    }

    protected void readResponseHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        String line;
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        }
        this.responseHeaders.clear();
        while ((line = conn.readLine()) != null && line.length() >= 1) {
            String oldvalue;
            int colon = line.indexOf(":");
            if (colon < 0) {
                throw new HttpException("Unable to parse header: " + line);
            }
            String name = line.substring(0, colon).trim();
            String match = name.toLowerCase();
            String value = line.substring(colon + 1).trim();
            Header header = (Header)this.responseHeaders.get(match);
            header = null == header ? new Header(name, value) : (null != (oldvalue = header.getValue()) ? new Header(name, oldvalue + ", " + value) : new Header(name, value));
            this.responseHeaders.put(match, header);
        }
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        Header setCookieHeader = this.getResponseHeader("set-cookie2");
        if (null == setCookieHeader) {
            setCookieHeader = this.getResponseHeader("set-cookie");
        }
        if (setCookieHeader != null) {
            try {
                Cookie[] cookies = Cookie.parse(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), setCookieHeader);
                state.addCookies(cookies);
            }
            catch (Exception e) {
                log.error("processResponseHeaders(HttpState,HttpConnection)", e);
            }
        }
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readResponseBody(state, conn, out);
        out.close();
        this.responseBody = out.toByteArray();
    }

    protected void readResponseBody(HttpState state, HttpConnection conn, OutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("HttpMethodBase.readResponseBody(HttpState,HttpConnection)");
        }
        this.responseBody = null;
        int expectedLength = 0;
        int foundLength = 0;
        Header lengthHeader = this.getResponseHeader("Content-Length");
        Header transferEncodingHeader = this.getResponseHeader("Transfer-Encoding");
        if (null != lengthHeader) {
            try {
                expectedLength = Integer.parseInt(lengthHeader.getValue());
            }
            catch (NumberFormatException e) {}
        } else if (null != transferEncodingHeader) {
            if ("chunked".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                expectedLength = -1;
            }
        } else if (HttpMethodBase.canResponseHaveBody(this.statusCode)) {
            expectedLength = -1;
        }
        InputStream is = conn.getResponseInputStream(this);
        byte[] buffer = new byte[4096];
        int nb = 0;
        while (expectedLength == -1 || foundLength < expectedLength) {
            nb = is.read(buffer);
            if (nb == -1) break;
            if (out == null) {
                throw new IOException("Unable to buffer data");
            }
            if (wireLog.isInfoEnabled()) {
                wireLog.info("<< \"" + new String(buffer, 0, nb) + "\"");
            }
            out.write(buffer, 0, nb);
            foundLength += nb;
            if (expectedLength <= -1) continue;
            if (foundLength == expectedLength) break;
            if (foundLength <= expectedLength) continue;
            log.warn("HttpMethodBase.readResponseBody(): expected length (" + expectedLength + ") exceeded.  Found " + foundLength + " bytes.");
            break;
        }
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
    }

    public void recycle() {
        this.path = null;
        this.followRedirects = false;
        this.queryString = null;
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.statusCode = -1;
        this.statusText = null;
        this.used = false;
        this.http11 = true;
        this.bodySent = false;
        this.responseBody = null;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public void setHttp11(boolean http11) {
        this.http11 = http11;
    }

    protected void checkNotUsed() {
        if (this.used) {
            throw new IllegalStateException("Already used.");
        }
    }

    protected void checkUsed() {
        if (!this.used) {
            throw new IllegalStateException("Not Used.");
        }
    }

    protected static String generateRequestLine(HttpConnection connection, String name, String reqPath, String qString, String protocol) {
        StringBuffer buf = new StringBuffer();
        buf.append(null == reqPath ? "/" : URIUtil.encode(reqPath, URIUtil.pathSafe()));
        if (null != qString) {
            if (qString.indexOf("?") < 0) {
                buf.append("?");
            }
            buf.append(qString);
        }
        if (!connection.isProxied()) {
            return name + " " + buf.toString() + " " + protocol + "\r\n";
        }
        if (connection.isSecure()) {
            return name + " https://" + connection.getHost() + (443 == connection.getPort() || -1 == connection.getPort() ? "" : ":" + connection.getPort()) + buf.toString() + " " + protocol + "\r\n";
        }
        return name + " http://" + connection.getHost() + (80 == connection.getPort() || -1 == connection.getPort() ? "" : ":" + connection.getPort()) + buf.toString() + " " + protocol + "\r\n";
    }

    private static boolean canResponseHaveBody(int status) {
        boolean result = true;
        if (status >= 100 && status <= 199 || status == 204 || status == 304) {
            result = false;
        }
        return result;
    }
}

