/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class DefaultLogTargetFactoryManager
extends AbstractLogEnabled
implements LogTargetFactoryManager,
Contextualizable,
Configurable {
    private final Map m_factories = new HashMap();
    private Context m_context;
    private ClassLoader m_classLoader;

    public final LogTargetFactory getLogTargetFactory(String factoryName) {
        return (LogTargetFactory)this.m_factories.get(factoryName);
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
        try {
            this.m_classLoader = (ClassLoader)this.m_context.get((Object)"classloader");
        }
        catch (ContextException contextException) {
            // empty catch block
        }
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] confs = configuration.getChildren("factory");
        int i = 0;
        while (i < confs.length) {
            LogTargetFactory logTargetFactory;
            String factoryClass = confs[i].getAttribute("class");
            String factoryType = confs[i].getAttribute("type");
            try {
                Class<?> clazz = null;
                if (null != this.m_classLoader) {
                    try {
                        clazz = this.m_classLoader.loadClass(factoryClass);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (null == clazz && null != classLoader) {
                    try {
                        clazz = classLoader.loadClass(factoryClass);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (null == clazz) {
                    clazz = this.getClass().getClassLoader().loadClass(factoryClass);
                }
                logTargetFactory = (LogTargetFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("cannot find LogTargetFactory class " + factoryClass, (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new ConfigurationException("cannot instantiate LogTargetFactory class " + factoryClass, (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigurationException("cannot access LogTargetFactory class " + factoryClass, (Throwable)iae);
            }
            ContainerUtil.enableLogging((Object)logTargetFactory, (Logger)this.getLogger());
            try {
                ContainerUtil.contextualize((Object)logTargetFactory, (Context)this.m_context);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("cannot contextualize LogTargetFactory " + factoryClass, (Throwable)ce);
            }
            ContainerUtil.configure((Object)logTargetFactory, (Configuration)confs[i]);
            if (logTargetFactory instanceof LogTargetFactoryManageable) {
                ((LogTargetFactoryManageable)((Object)logTargetFactory)).setLogTargetFactoryManager(this);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added new LogTargetFactory of type " + factoryType);
            }
            this.m_factories.put(factoryType, logTargetFactory);
            ++i;
        }
    }
}

