/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.pizzacompiler.compiler.GeneralFile;
import net.sf.pizzacompiler.compiler.ZippedFile;

class ZipDir
extends GeneralFile {
    File f;
    RandomAccessFile r;
    String[] filenames;
    int[] offsets;
    String prefix;

    ZipDir(File file) {
        try {
            this.f = file;
            this.r = new RandomAccessFile(file, "r");
            byte[] byArray = this.findDir(this.r);
            int n = ZippedFile.get2LE(byArray, 0);
            this.filenames = new String[n];
            this.offsets = new int[n];
            if (n > 0) {
                int n2 = 2;
                for (int i = 0; i < n; ++i) {
                    n2 = this.readEntry(byArray, n2, i);
                }
                this.sort(0, n - 1);
            }
        }
        catch (IOException iOException) {
            this.r = null;
        }
    }

    String getPath() {
        return this.f.getPath();
    }

    boolean exists() {
        return this.r != null;
    }

    boolean isDirectory() {
        return this.r != null;
    }

    byte[] read() throws IOException {
        throw new IOException("can't read directory");
    }

    String[] list() throws IOException {
        return ZippedFile.list(this, "");
    }

    GeneralFile open(String string) {
        return new ZippedFile(this, string);
    }

    int index(String string) {
        int n = 0;
        int n2 = this.filenames.length - 1;
        while (n <= n2) {
            int n3 = (n2 + n) / 2;
            int n4 = string.compareTo(this.filenames[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    byte[] findDir(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[1024];
        int n = byArray.length;
        long l = randomAccessFile.length();
        while (l >= 22L) {
            int n2;
            if (l < (long)n) {
                n = (int)l;
            }
            long l2 = l - (long)n;
            randomAccessFile.seek(l2);
            if (randomAccessFile.read(byArray, 0, n) != n) {
                throw new IOException("read error");
            }
            for (n2 = n - 22; n2 >= 0 && (byArray[n2] != 80 || byArray[n2 + 1] != 75 || byArray[n2 + 2] != 5 || byArray[n2 + 3] != 6 || l2 + (long)n2 + 22L + (long)ZippedFile.get2LE(byArray, n2 + 20) != randomAccessFile.length()); --n2) {
            }
            if (n2 >= 0) {
                byte[] byArray2 = new byte[ZippedFile.get4LE(byArray, n2 + 12) + 2];
                byArray2[0] = byArray[n2 + 10];
                byArray2[1] = byArray[n2 + 11];
                randomAccessFile.seek(ZippedFile.get4LE(byArray, n2 + 16));
                if (randomAccessFile.read(byArray2, 2, byArray2.length - 2) != byArray2.length - 2) {
                    throw new IOException("read error");
                }
                return byArray2;
            }
            l = l2 + 21L;
        }
        throw new IOException("bad zip file");
    }

    int readEntry(byte[] byArray, int n, int n2) throws IOException {
        if (ZippedFile.get4LE(byArray, n) != 33639248) {
            throw new IOException("bad dir entry");
        }
        if (ZippedFile.get2LE(byArray, n + 10) != 0) {
            throw new IOException("can't handle compressed zip files");
        }
        this.offsets[n2] = ZippedFile.get4LE(byArray, n + 42);
        this.filenames[n2] = new String(byArray, 0, n + 46, ZippedFile.get2LE(byArray, n + 28)).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return n + 46 + ZippedFile.get2LE(byArray, n + 28) + ZippedFile.get2LE(byArray, n + 30) + ZippedFile.get2LE(byArray, n + 32);
    }

    private void sort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = this.filenames[(n3 + n4) / 2];
        while (true) {
            if (this.filenames[n3].compareTo(string) < 0) {
                ++n3;
                continue;
            }
            while (string.compareTo(this.filenames[n4]) < 0) {
                --n4;
            }
            if (n3 <= n4) {
                String string2 = this.filenames[n3];
                this.filenames[n3] = this.filenames[n4];
                this.filenames[n4] = string2;
                int n5 = this.offsets[n3];
                this.offsets[n3] = this.offsets[n4];
                this.offsets[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sort(n, n4);
        }
        if (n3 < n2) {
            this.sort(n3, n2);
        }
    }
}

