/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryByteRasterImage;
import com.sun.jimi.core.vmem.BytePageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;

public class VMemByteRasterImage
extends MemoryByteRasterImage {
    protected BytePageMapper pageMapper;
    protected byte[] rowBuffer;
    protected byte[] pixelBuf = new byte[1];

    public VMemByteRasterImage(RandomAccessStorage randomAccessStorage, int n, int n2, ColorModel colorModel) throws JimiException {
        super(n, n2, colorModel);
        this.pageMapper = new BytePageMapper(randomAccessStorage, new Dimension(n, n2), 2048);
    }

    public byte[] asByteArray() {
        return null;
    }

    public byte getPixel(int n, int n2) throws ImageAccessException {
        this.getRectangle(n, n2, 1, 1, this.pixelBuf, 0, 0);
        return this.pixelBuf[0];
    }

    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        try {
            this.pageMapper.getRectangle(n, n2, n3, n4, byArray, n5, n6);
        }
        catch (IOException iOException) {
            throw new ImageAccessException(iOException.getMessage());
        }
    }

    public int getRectangleRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(n, n2));
    }

    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        ColorModel colorModel = this.getColorModel();
        if (this.rowBuffer == null) {
            this.rowBuffer = new byte[this.getWidth()];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRectangle(n, n2 + n7, n3, 1, this.rowBuffer, 0, 0);
            int n8 = 0;
            while (n8 < n3) {
                nArray[n5++] = colorModel.getRGB(this.rowBuffer[n8] & 0xFF);
                ++n8;
            }
            n5 += n6 - n3;
            ++n7;
        }
    }

    protected void initStorage() throws JimiException {
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        try {
            int n = this.pageMapper.getPageDimensions().height;
            int n2 = rectangle.x;
            int n3 = rectangle.y;
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            ColorModel colorModel = this.getColorModel();
            int n6 = 5;
            n6 = Math.max(1, n6);
            byte[] byArray = new byte[n4 * n6];
            int n7 = 0;
            while (n7 < n5) {
                int n8 = Math.min(n6, n5 - n7);
                this.getRectangle(n2, n7 + n3, n4, n8, byArray, 0, n4);
                imageConsumer.setPixels(0, n7, n4, n8, colorModel, byArray, 0, n4);
                n7 += n8;
            }
        }
        catch (Exception exception) {
            throw new ImageAccessException();
        }
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        int n = this.pageMapper.getPageDimensions().height;
        byte[] byArray = new byte[this.getWidth() * n];
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = 0;
        ColorModel colorModel = this.getColorModel();
        while (n4 < n2) {
            int n5 = Math.min(n, n2 - n4);
            this.getRectangle(0, n4, n3, n5, byArray, 0, n3);
            imageConsumer.setPixels(0, n4, n3, n5, this.colorModel, byArray, 0, n3);
            n4 += n5;
        }
    }

    public void storePixel(int n, int n2, byte by) throws ImageAccessException {
        this.pixelBuf[0] = by;
        this.setRectangle(n, n2, 1, 1, this.pixelBuf, 0, 0);
    }

    public void storeRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        try {
            this.pageMapper.setRectangle(n, n2, n3, n4, byArray, n5, n6);
        }
        catch (IOException iOException) {
            throw new ImageAccessException(iOException.getMessage());
        }
    }
}

