/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.excalibur.collections.BucketMap;
import org.apache.avalon.excalibur.component.AbstractDualLogEnabled;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.component.ThreadSafeComponentHandler;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;

public class ExcaliburComponentManager
extends AbstractDualLogEnabled
implements ComponentManager,
Configurable,
Contextualizable,
Initializable,
Disposable,
RoleManageable,
LogKitManageable,
InstrumentManageable,
Instrumentable {
    public static final String INSTRUMENTABLE_NAME = "component-manager";
    private final ComponentManager m_parentManager;
    private final ClassLoader m_loader;
    private Context m_context;
    private final BucketMap m_componentMapping = new BucketMap();
    private final BucketMap m_componentHandlers = new BucketMap();
    private final List m_newComponentHandlers = new ArrayList();
    private RoleManager m_roles;
    private LogkitLoggerManager m_logkit;
    private boolean m_disposed;
    private boolean m_initialized;
    private InstrumentManager m_instrumentManager;
    private String m_instrumentableName = "component-manager";

    public ExcaliburComponentManager() {
        this(null, Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentManager(ClassLoader loader) {
        this(null, loader);
    }

    public ExcaliburComponentManager(ComponentManager manager, ClassLoader loader) {
        this.m_loader = null == loader ? Thread.currentThread().getContextClassLoader() : loader;
        this.m_parentManager = manager;
    }

    public ExcaliburComponentManager(ComponentManager manager) {
        this(manager, Thread.currentThread().getContextClassLoader());
    }

    public Component lookup(String role) throws ComponentException {
        if (!this.m_initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized ComponentLocator [" + role + "]");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ComponentLocator");
        }
        if (null == role) {
            String message = "ComponentLocator Attempted to retrieve component with null role.";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("ComponentLocator Attempted to retrieve component with null role.");
            }
            throw new ComponentException(role, "ComponentLocator Attempted to retrieve component with null role.");
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get((Object)role));
        if (null == handler) {
            block25: {
                if (this.m_parentManager != null) {
                    try {
                        return this.m_parentManager.lookup(role);
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isWarnEnabled()) break block25;
                        String message = "ComponentLocator exception from parent CM during lookup.";
                        this.getLogger().warn("ComponentLocator exception from parent CM during lookup.", (Throwable)e);
                    }
                }
            }
            if (null != this.m_roles) {
                String className = this.m_roles.getDefaultClassNameForRole(role);
                if (null != className) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role [" + role + "]");
                    }
                    try {
                        Class<?> componentClass = this.m_loader.loadClass(className);
                        DefaultConfiguration configuration = new DefaultConfiguration("", "-");
                        handler = this.getComponentHandler(componentClass, (Configuration)configuration, this.m_context, this.m_roles, this.m_logkit);
                        handler.setLogger(this.getLogkitLogger());
                        handler.enableLogging(this.getLogger());
                        handler.initialize();
                    }
                    catch (Exception e) {
                        String message = "Could not find component";
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Could not find component for role: " + role, (Throwable)e);
                        }
                        throw new ComponentException(role, "Could not find component", (Throwable)e);
                    }
                    this.m_componentHandlers.put((Object)role, (Object)handler);
                }
            } else {
                this.getLogger().debug("Component requested without a RoleManager set.\nThat means setRoleManager() was not called during initialization.");
            }
        }
        if (null == handler) {
            String message = "Could not find component";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not find component for role: " + role);
            }
            throw new ComponentException(role, "Could not find component");
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (IllegalStateException ise) {
            try {
                handler.initialize();
                component = handler.get();
            }
            catch (ComponentException ce) {
                throw ce;
            }
            catch (Exception e) {
                String message = "Could not access the Component";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Could not access the Component for role [" + role + "]", (Throwable)e);
                }
                throw new ComponentException(role, "Could not access the Component", (Throwable)e);
            }
        }
        catch (Exception e) {
            String message = "Could not access the Component";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not access the Component for role [" + role + "]", (Throwable)e);
            }
            throw new ComponentException(role, "Could not access the Component", (Throwable)e);
        }
        this.m_componentMapping.put((Object)component, (Object)handler);
        return component;
    }

    public boolean hasComponent(String role) {
        if (!this.m_initialized) {
            return false;
        }
        if (this.m_disposed) {
            return false;
        }
        boolean exists = this.m_componentHandlers.containsKey((Object)role);
        if (!exists && null != this.m_parentManager) {
            exists = this.m_parentManager.hasComponent(role);
        }
        return exists;
    }

    public void release(Component component) {
        if (null == component) {
            this.getLogger().warn("Attempted to release a null component.");
            return;
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get((Object)component));
        if (null != handler) {
            if (!(handler instanceof ThreadSafeComponentHandler)) {
                this.m_componentMapping.remove((Object)component);
            }
            try {
                handler.put(component);
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Error trying to release component.", (Throwable)e);
                }
            }
        } else if (null != this.m_parentManager) {
            this.m_parentManager.release(component);
        } else {
            this.getLogger().warn("Attempted to release a " + component.getClass().getName() + " but its handler could not be located.");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_roles) {
            DefaultRoleManager roleInfo = new DefaultRoleManager();
            roleInfo.enableLogging(this.getLogger());
            roleInfo.configure(configuration);
            this.m_roles = roleInfo;
            this.getLogger().debug("No RoleManager given, deriving one from configuration");
        }
        Configuration[] configurations = configuration.getChildren();
        int i = 0;
        while (i < configurations.length) {
            String type = configurations[i].getName();
            if (!type.equals("role")) {
                String role = configurations[i].getAttribute("role", "");
                String className = configurations[i].getAttribute("class", "");
                if (role.equals("")) {
                    role = this.m_roles.getRoleForName(type);
                }
                if (null != role && !role.equals("")) {
                    if (className.equals("")) {
                        className = this.m_roles.getDefaultClassNameForRole(role);
                    }
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Adding component (" + role + " = " + className + ")");
                        }
                        Class<?> clazz = this.m_loader.loadClass(className);
                        this.addComponent(role, clazz, configurations[i]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String message = "Could not get class ";
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Could not get class " + className + " for role " + role + " on configuration element " + configurations[i].getName(), (Throwable)cnfe);
                        }
                        throw new ConfigurationException("Could not get class ", (Throwable)cnfe);
                    }
                    catch (ComponentException ce) {
                        String message = "Bad component ";
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Bad component " + className + " for role " + role + " on configuration element " + configurations[i].getName(), (Throwable)ce);
                        }
                        throw new ConfigurationException("Bad component ", (Throwable)ce);
                    }
                    catch (Exception e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Unexpected exception for hint: " + role, (Throwable)e);
                        }
                        throw new ConfigurationException("Unexpected exception", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void contextualize(Context context) {
        if (null == this.m_context) {
            this.m_context = context;
        }
    }

    public void initialize() throws Exception {
        if (this.m_instrumentManager != null) {
            this.m_instrumentManager.registerInstrumentable((Instrumentable)this, this.m_instrumentableName);
        }
        ExcaliburComponentManager excaliburComponentManager = this;
        synchronized (excaliburComponentManager) {
            this.m_initialized = true;
            int i = 0;
            while (i < this.m_newComponentHandlers.size()) {
                block13: {
                    ComponentHandler handler = (ComponentHandler)((Object)this.m_newComponentHandlers.get(i));
                    try {
                        handler.initialize();
                        if (this.m_instrumentManager != null && handler instanceof Instrumentable) {
                            String handleInstName = handler.getInstrumentableName();
                            this.m_instrumentManager.registerInstrumentable((Instrumentable)handler, handleInstName);
                        }
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isErrorEnabled()) break block13;
                        this.getLogger().error("Caught an exception trying to initialize the component handler.", (Throwable)e);
                    }
                }
                ++i;
            }
            ArrayList keys = new ArrayList(this.m_componentHandlers.keySet());
            int i2 = 0;
            while (i2 < keys.size()) {
                block14: {
                    Object key = keys.get(i2);
                    ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                    if (!this.m_newComponentHandlers.contains((Object)handler)) {
                        try {
                            handler.initialize();
                            if (this.m_instrumentManager != null && handler instanceof Instrumentable) {
                                String handleInstName = handler.getInstrumentableName();
                                this.m_instrumentManager.registerInstrumentable((Instrumentable)handler, handleInstName);
                            }
                        }
                        catch (Exception e) {
                            if (!this.getLogger().isErrorEnabled()) break block14;
                            this.getLogger().error("Caught an exception trying to initialize the component handler.", (Throwable)e);
                        }
                    }
                }
                ++i2;
            }
            this.m_newComponentHandlers.clear();
        }
    }

    public void dispose() {
        ExcaliburComponentManager excaliburComponentManager = this;
        synchronized (excaliburComponentManager) {
            boolean forceDisposal = false;
            ArrayList disposed = new ArrayList();
            while (this.m_componentHandlers.size() > 0) {
                Iterator iterator = this.m_componentHandlers.keySet().iterator();
                while (iterator.hasNext()) {
                    Object role = iterator.next();
                    ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(role));
                    if (!forceDisposal && !handler.canBeDisposed()) continue;
                    if (forceDisposal && this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("disposing of handler for unreleased component. role [" + role + "]");
                    }
                    handler.dispose();
                    disposed.add(role);
                }
                if (disposed.size() > 0) {
                    this.removeDisposedHandlers(disposed);
                    continue;
                }
                forceDisposal = true;
            }
            this.m_disposed = true;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (null == this.m_roles) {
            this.m_roles = roles;
        }
    }

    public void setLogKitManager(LogKitManager logkit) {
        if (null == this.m_logkit) {
            this.m_logkit = new LogkitLoggerManager(null, logkit);
        }
    }

    public void setInstrumentManager(InstrumentManager instrumentManager) {
        this.m_instrumentManager = instrumentManager;
    }

    public void setInstrumentableName(String name) {
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return Instrumentable.EMPTY_INSTRUMENT_ARRAY;
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    private void removeDisposedHandlers(List disposed) {
        Iterator iterator = disposed.iterator();
        while (iterator.hasNext()) {
            this.m_componentHandlers.remove(iterator.next());
        }
        disposed.clear();
    }

    public void setLoggerManager(LoggerManager logkit) {
        if (null == this.m_logkit) {
            this.m_logkit = new LogkitLoggerManager(logkit, null);
        }
    }

    protected ComponentHandler getComponentHandler(Class componentClass, Configuration configuration, Context context, RoleManager roleManager, LogkitLoggerManager logkitManager) throws Exception {
        String instrumentableName = configuration.getAttribute("instrumentable", configuration.getName());
        return ComponentHandler.getComponentHandler(componentClass, configuration, this, context, roleManager, logkitManager, this.m_instrumentManager, instrumentableName);
    }

    public void addComponent(String role, Class component, Configuration configuration) throws ComponentException {
        if (this.m_initialized) {
            throw new ComponentException(role, "Cannot add components to an initialized ComponentLocator");
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Attempting to get Handler for role [" + role + "]");
            }
            ComponentHandler handler = this.getComponentHandler(component, configuration, this.m_context, this.m_roles, this.m_logkit);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Handler type = " + ((Object)((Object)handler)).getClass().getName());
            }
            handler.setLogger(this.getLogkitLogger());
            handler.enableLogging(this.getLogger());
            this.m_componentHandlers.put((Object)role, (Object)handler);
            this.m_newComponentHandlers.add(handler);
        }
        catch (Exception e) {
            throw new ComponentException(role, "Could not set up Component.", (Throwable)e);
        }
    }

    public void addComponentInstance(String role, Component instance) {
        block3: {
            if (this.m_initialized) {
                throw new IllegalStateException("Cannot add components to an initialized ComponentLocator");
            }
            try {
                ComponentHandler handler = ComponentHandler.getComponentHandler(instance);
                handler.setLogger(this.getLogkitLogger());
                handler.enableLogging(this.getLogger());
                this.m_componentHandlers.put((Object)role, (Object)handler);
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Could not set up Component for role [" + role + "]", (Throwable)e);
            }
        }
    }
}

