/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserImpl
extends javax.xml.parsers.SAXParser {
    private XMLReader xmlReader = new SAXParser();
    private String schemaLanguage = null;

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        if (sAXParserFactory.isValidating()) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", sAXParserFactory.isValidating());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", sAXParserFactory.isNamespaceAware());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", !sAXParserFactory.isNamespaceAware());
        this.setFeatures(hashtable);
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature(string, bl);
            }
        }
    }

    public Parser getParser() throws SAXException {
        return (Parser)((Object)this.xmlReader);
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(object)) {
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                return;
            } else {
                if (object != null) throw new SAXNotSupportedException("Unsupported schema language");
                this.schemaLanguage = null;
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            return;
        } else {
            this.xmlReader.setProperty(string, object);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(string);
    }
}

