/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BorderStyle;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ColorCode;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.EPStyle;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.HSSFColor;

public class EPLeft
extends BaseElementProcessor {
    private NumericResult _style = null;
    private ColorCode _color = null;
    private boolean _color_fetched = false;
    private static final String _style_attribute = "Style";
    private static final String _color_attribute = "Color";
    private static final Validator _style_validator = new Validator(){

        public IOException validate(Number number) {
            return BorderStyle.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };
    static /* synthetic */ Class class$org$apache$cocoon$components$elementprocessor$impl$poi$hssf$elements$EPStyle;

    public EPLeft() {
        super(null);
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        EPStyle pstyle = (EPStyle)this.getAncestor(class$org$apache$cocoon$components$elementprocessor$impl$poi$hssf$elements$EPStyle == null ? (class$org$apache$cocoon$components$elementprocessor$impl$poi$hssf$elements$EPStyle = EPLeft.class$("org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.EPStyle")) : class$org$apache$cocoon$components$elementprocessor$impl$poi$hssf$elements$EPStyle);
        if (pstyle != null && pstyle.isValid()) {
            Hashtable colorhash = pstyle.getColorHash();
            HSSFColor color = null;
            HSSFCellStyle style = pstyle.getStyle();
            style.setBorderLeft((short)this.getStyle());
            ColorCode colorCode = this.getColor();
            if (colorCode != null) {
                color = (HSSFColor)colorhash.get(colorCode.toString());
            }
            if (color == null) {
                color = new HSSFColor.BLACK();
            }
            style.setLeftBorderColor(color.getIndex());
        }
    }

    public int getStyle() throws IOException {
        if (this._style == null) {
            this._style = NumericConverter.extractInteger(this.getValue(_style_attribute), _style_validator);
        }
        return this._style.intValue();
    }

    public ColorCode getColor() throws IOException {
        if (!this._color_fetched) {
            String colorString = this.getValue(_color_attribute);
            if (colorString != null) {
                this._color = new ColorCode(colorString);
            }
            this._color_fetched = true;
        }
        return this._color;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

