/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.request;

import java.io.File;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.components.request.RequestFactory;
import org.apache.cocoon.components.request.multipart.MultipartRequestWrapper;

public final class MultipartRequestFactoryImpl
extends RequestFactory {
    public HttpServletRequest getServletRequest(HttpServletRequest request, boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize) {
        HttpServletRequest req = request;
        String contentType = req.getContentType();
        if (contentType == null) {
            contentType = "application/x-www-form-urlencoded";
        }
        if (contentType.startsWith("multipart/form-data")) {
            try {
                req = new MultipartRequestWrapper(request, saveUploadedFilesToDisk, uploadDirectory, allowOverwrite, silentlyRename, maxUploadSize);
            }
            catch (Exception e) {
                req = request;
            }
        }
        return req;
    }

    public Object get(HttpServletRequest request, String name) {
        if (request instanceof MultipartRequestWrapper) {
            return ((MultipartRequestWrapper)request).get(name);
        }
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length > 1) {
            Vector<String> vect = new Vector<String>(values.length);
            int i = 0;
            while (i < values.length) {
                vect.add(values[i]);
                ++i;
            }
            return vect;
        }
        return null;
    }
}

