/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.CallNode;
import org.apache.cocoon.components.treeprocessor.sitemap.RedirectToURINode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;

public class RedirectToNodeBuilder
extends AbstractProcessingNodeBuilder
implements LinkedProcessingNodeBuilder {
    private CallNode callNode;
    private String resourceName;

    protected boolean hasParameters() {
        return false;
    }

    public ProcessingNode buildNode(Configuration config2) throws Exception {
        this.resourceName = config2.getAttribute("resource", null);
        if (this.resourceName != null) {
            this.getLogger().warn("Redirect to resource is deprecated. Use map:call instead at " + config2.getLocation());
            this.callNode = new CallNode();
            this.treeBuilder.setupNode(this.callNode, config2);
            String target = config2.getAttribute("target", null);
            if (target != null) {
                HashMap<String, VariableResolver> params = new HashMap<String, VariableResolver>(1);
                params.put("target", VariableResolverFactory.getResolver(target, this.manager));
                this.callNode.setParameters(params);
            }
            return this.callNode;
        }
        RedirectToURINode URINode = new RedirectToURINode(VariableResolverFactory.getResolver(config2.getAttribute("uri"), this.manager), config2.getAttributeAsBoolean("session", false));
        return this.treeBuilder.setupNode(URINode, config2);
    }

    public void linkNode() throws Exception {
        if (this.callNode != null) {
            CategoryNode resources = CategoryNodeBuilder.getCategoryNode(this.treeBuilder, "resources");
            if (resources == null) {
                String msg = "This sitemap contains no resources. Cannot redirect at " + this.callNode.getLocation();
                this.getLogger().error(msg);
                throw new ConfigurationException(msg);
            }
            this.callNode.setResource(resources, this.resourceName);
        }
    }
}

